% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_species.r
\name{abundances}
\alias{abundances}
\title{Generates simulated species abundances}
\usage{
abundances(env, spp, nc)
}
\arguments{
\item{env}{Environmental variables.
Usually generated by \code{\link{make.env}}.
Users may as well supply own environmental variables.}

\item{spp}{Species parameters. Usually generated by \code{\link{species}}.}

\item{nc}{Count sum to be simulated.
If omitted no simulation of the counting process is carried out.}
}
\value{
A list with two elements:
\item{spp}{A data frame with species abundances.}
\item{env}{A data frame with environmental variables.}
}
\description{
Generates species abundances based on species response functions
and environmental variables.
}
\examples{
spec <- species(
  nspp = 30, ndim = 10, Amax = runif, fun = runif,
  xpar = c(-50, 150), srange = 200, alpha = 4, gamma = 4
)
env.var <- make.env(100,
  elen = rep(100, 10), emean = rep(50, 10),
  edistr = "uniform", ndim = 10
)
spec.abun <- abundances(env.var, spec, 200)
}
\references{
Minchin, P.R. (1987) Multidimensional Community Patterns:
Towards a Comprehensive Model. \emph{Vegetatio}, \strong{71}, 145-156.
\doi{10.1007/BF00039167}
}
\seealso{
\code{\link{make.env}}, \code{\link{species}}
}
\author{
Mathias Trachsel and Richard J. Telford
}
\keyword{datagen}
