% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q3.R
\name{q3}
\alias{q3}
\title{Q3 Fit Statistic}
\usage{
q3(
  pers_obj,
  na_treat = 0,
  use = "complete.obs",
  res = "stdr",
  method = "pearson"
)
}
\arguments{
\item{pers_obj}{an object of class \code{"pers"} as a result from function \code{\link{pers}}.}

\item{na_treat}{value to be assigned to residual cells which have missing data in the original response matrix. default is set to \code{na_treat=0} to set the residuals to 0, which implys that they are imputed as 'fitting data', i.e., zero residuals. This can attenuate contrasts (see. http://www.rasch.org/rmt/rmt142m.htm). An option is to set it to \code{na_treat=NA}.}

\item{use}{a character string as used in function \code{\link{cor}} or \code{\link{cov}}, giving a method for computing covariances or correlations in the presence of missing values. This must be (an abbreviation of) one of the strings "everything", "all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs". The default is set to \code{use="complete.obs"} which will exclude cases by listwise deletion to keep the correlation matrix positive definit.}

\item{res}{a character string defining which type of (rasch--) residual to analyze when computing the correlations. This must be (exactly) one of the strings "sr" for score residuals , "stdr" for standardised residuals, "srsq" for score residuals squared, or "stdrsq" for standardised residuals squared. The default is set to \code{res="stdr"} refering to Linacre (1998).}

\item{method}{a character string as used in function \code{\link{cor}}, indicating which correlation coefficient  is to be computed. One of "pearson" (default), "kendall", or "spearman", can be abbreviated. The default is set to \code{method="pearson"}.}
}
\value{
An object of class \code{c("Q3","list")}.
}
\description{
Calculation of Q3 fit statistic for the rasch model based on the residuals, which was proposed by Yen (1984).
}
\details{
The lower level letter 'q' was used (intead of 'Q') for naming the function because the name 'Q3' was already used in another IRT package -- namly \code{TAM}. As perhaps some users like to use both packages simultaniously, an alternative naming convention was choosen for 'pairwise'. No other details in the moment.
}
\examples{
######################
########
data(bfiN) # loading reponse data
pers_obj <- pers(pair(bfiN))
result <- q3(pers_obj)
str(result) # to see whats in ;-)
#### 
}
\references{
Yen, W. M. (1984). Effects of Local Item Dependence on the Fit and Equating Performance of the Three-Parameter Logistic Model. \emph{Applied Psychological Measurement, 8}(2), 125–145. https://doi.org/10.1177/014662168400800201
}
\keyword{fit}
\keyword{model}
