% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-osmdata-sc.R
\name{osmdata_sc}
\alias{osmdata_sc}
\title{Return an OSM Overpass query as an \code{osmdata_sc} object in
\code{silicate} (\code{SC}) format.}
\usage{
osmdata_sc(q, doc, quiet = TRUE)
}
\arguments{
\item{q}{An object of class \code{overpass_query} constructed with
\link{opq} and \link{add_osm_feature} or a string with a valid query, such
as \code{"(node(39.4712701,-0.3841326,39.4713799,-0.3839475);); out;"}.
39.4712701,-0.3841326,39.4713799,-0.3839475
May be be omitted, in which case the \link{osmdata} object will not
include the query. See examples below.}

\item{doc}{If missing, \code{doc} is obtained by issuing the overpass query,
\code{q}, otherwise either the name of a file from which to read data,
or an object of class \pkg{xml2} returned from \link{osmdata_xml}.}

\item{quiet}{suppress status messages.}
}
\value{
An object of class \code{osmdata_sc} representing the original OSM
hierarchy of nodes, ways, and relations.
}
\description{
Return an OSM Overpass query as an \code{osmdata_sc} object in
\code{silicate} (\code{SC}) format.
}
\note{
The \code{silicate} format is currently highly experimental, and
recommended for use only if you really know what you're doing.
}
\examples{
\dontrun{
query <- opq ("hampi india") |>
    add_osm_feature (key = "historic", value = "ruins")
# Then extract data from 'Overpass' API
hampi_sc <- osmdata_sc (query)
}

# Complex query as a string (not possible with regular osmdata functions)
q <- '[out:xml][timeout:50];
    area[name="Països Catalans"][boundary=political]->.boundaryarea;

    rel(area.boundaryarea)[admin_level=8][boundary=administrative];
    map_to_area -> .all_level_8_areas;

    ( nwr(area.boundaryarea)[amenity=townhall]; >; );
    is_in;
    area._[admin_level=8][boundary=administrative] -> .level_8_areas_with_townhall;

    (.all_level_8_areas; - .level_8_areas_with_townhall;);
    rel(pivot);
    (._; >;);
    out;'

\dontrun{
no_townhall <- osmdata_sc (q)
no_townhall
}
}
\seealso{
Other extract: 
\code{\link{osmdata_data_frame}()},
\code{\link{osmdata_sf}()},
\code{\link{osmdata_sp}()},
\code{\link{osmdata_xml}()}
}
\concept{extract}
