% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockVocabulary.R
\name{mockVocabularyTables}
\alias{mockVocabularyTables}
\title{Creates a mock CDM database populated with various vocabulary tables.}
\usage{
mockVocabularyTables(
  cdm = mockCdmReference(),
  vocabularySet = "mock",
  cdmSource = NULL,
  concept = NULL,
  vocabulary = NULL,
  conceptRelationship = NULL,
  conceptSynonym = NULL,
  conceptAncestor = NULL,
  drugStrength = NULL
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object that serves as the base structure for adding vocabulary tables.
This should be an existing or a newly created CDM object, typically initialized without any vocabulary tables.}

\item{vocabularySet}{A character string specifying the name of the vocabulary set
to be used when creating the vocabulary tables for the CDM.
Options are "mock" or "eunomia":
\itemize{
\item "mock": Provides a very small synthetic vocabulary subset,
suitable for tests that do not require realistic vocabulary
names or relationships.
\item "eunomia": Uses the vocabulary from the Eunomia test database,
which contains real vocabularies available from ATHENA.
}}

\item{cdmSource}{An optional data frame representing the CDM source table.
If provided, it will be used directly; otherwise, a mock table will be generated based on the \code{vocabularySet} prefix.}

\item{concept}{An optional data frame representing the concept table.
If provided, it will be used directly; if NULL, a mock table will be generated.}

\item{vocabulary}{An optional data frame representing the vocabulary table.
If provided, it will be used directly; if NULL, a mock table will be generated.}

\item{conceptRelationship}{An optional data frame representing the concept relationship table.
If provided, it will be used directly; if NULL, a mock table will be generated.}

\item{conceptSynonym}{An optional data frame representing the concept synonym table.
If provided, it will be used directly; if NULL, a mock table will be generated.}

\item{conceptAncestor}{An optional data frame representing the concept ancestor table.
If provided, it will be used directly; if NULL, a mock table will be generated.}

\item{drugStrength}{An optional data frame representing the drug strength table.
If provided, it will be used directly; if NULL, a mock table will be generated.}
}
\value{
Returns the modified \code{cdm} object with the new or provided vocabulary tables added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This function adds specified vocabulary tables to a CDM object. It can either populate the tables with provided data frames or initialize empty tables if no data is provided. This is useful for setting up a testing environment with controlled vocabulary data.
}
\examples{
library(omock)

# Create a mock CDM reference and populate it with mock vocabulary tables
cdm <- mockCdmReference() |> mockVocabularyTables(vocabularySet = "mock")

# View the names of the tables added to the CDM
names(cdm)
}
