% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-report.R
\name{report_op_html}
\alias{report_op_html}
\title{Create an HTML report document containing RAM-OP survey results}
\usage{
report_op_html(
  estimates,
  svy,
  indicators = c("demo", "food", "hunger", "disability", "adl", "mental", "dementia",
    "health", "income", "wash", "anthro", "oedema", "screening", "visual", "misc"),
  filename = paste(tempdir(), "ramOPreport", sep = "/"),
  title = "RAM-OP Report",
  view = FALSE
)
}
\arguments{
\item{estimates}{A data.frame of RAM-OP results produced by \code{\link[=merge_op]{merge_op()}}.}

\item{svy}{A data.frame collected using the standard RAM-OP questionnaire}

\item{indicators}{A character vector of indicator names}

\item{filename}{Filename for output document. Can be specified as a path to a
specific directory where to output report document. Defaults to a path to
a temporary directory and a filename `ramOPreport``.}

\item{title}{Title of report}

\item{view}{Logical. Open report in current browser? Default is FALSE.}
}
\value{
An HTML document in the working directory or if filename is a path,
to a specified directory.
}
\description{
Create an HTML report document containing RAM-OP survey results
}
\examples{
classicResults <- estimate_classic(
  x = create_op(testSVY), w = testPSU, replicates = 9
)

probitResults <- estimate_probit(
  x = create_op(testSVY), w = testPSU, replicates = 9
)

resultsDF <- merge_op(x = classicResults, y = probitResults)

if (rmarkdown::pandoc_available("1.12.3")) {
  report_op_html(
    svy = testSVY, estimates = resultsDF, indicators = "mental",
    filename = paste(tempdir(), "report", sep = "/")
  )
}

}
\author{
Ernest Guevarra
}
