% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-validation.R
\name{match_species}
\alias{match_species}
\title{Match species names to their GBIF backbone ids}
\usage{
match_species(speciesnames, exact = FALSE, returnids = TRUE, omit = TRUE)
}
\arguments{
\item{speciesnames}{a vector of species names to match to the GBIF backbone.}

\item{exact}{whether to only return exact \emph{species} matches.}

\item{returnids}{return the GBIF taxon ids only (otherwise return the full lookup dataframe).}

\item{omit}{omit missing taxon ids (inactive when \code{returnids = FALSE}).}
}
\value{
The GBIF taxonids associated with \code{speciesnames} or the full GBIF lookup dataframe if \code{returnids = TRUE}.
}
\description{
Match species names to their GBIF backbone ids using \code{\link[rgbif:name_backbone_checklist]{rgbif::name_backbone_checklist()}}.
}
\note{
If \code{exact = TRUE} and you search for a genus name, this will not be returned.
If you want more control over id filtering, use \code{returnids = FALSE} to get the source dataframe.
}
\examples{
match_species(c("Araneus diadematus", "Aedes aegypti"))

}
\author{
Francis Windram
}
\concept{convenience}
