% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_peaks_to_tss.R
\name{link_peaks_to_tss}
\alias{link_peaks_to_tss}
\title{Identifies ATAC-seq peaks surrounding each gene}
\usage{
link_peaks_to_tss(gtf_file, peaks_gr, gene_list = NA, tss_window = NA)
}
\arguments{
\item{gtf_file}{A character string specifying the path to a GTF file containing gene annotations.}

\item{peaks_gr}{A \code{GRanges} object representing the ATAC-seq peaks with their genomic locations and associated metadata.}

\item{gene_list}{A character vector of gene names to filter for. Only peaks within the window around TSS of these genes will be considered. Default is \code{NA}, in which case all genes in the GTF file will be used.}

\item{tss_window}{An integer specifying the window size around the TSS. Default is \code{100000} (±100kb).}
}
\value{
A data frame containing the following columns:
\item{peak}{The genomic coordinates of the peaks.}
\item{peak_id}{The unique ID of each peak.}
\item{gene_id}{The gene ID associated with the peak.}
\item{gene_name}{The gene name associated with the peak.}
\item{transcript_id}{The transcript ID associated with the peak.}
\item{gene_type}{The type of the gene (e.g., protein-coding).}
\item{distance}{The distance from the peak center to the TSS.}
}
\description{
This function identifies ATAC-seq peaks that are located within a specified window around
the transcription start sites (TSS) of genes, and links those peaks to the respective genes.
}
\examples{
\donttest{
# Load bulk mouse dataset
data(multiome_human_mouse)  # This will load atacseq_data, rnaseq_data, peaks_gr

# Path to the GTF file in the package
gtf_file <- system.file("extdata", "gencode.vM25.annotation.sample.gtf", package = "ocrRBBR")

# Example usage for linking peaks to TSS
linked_peaks <- link_peaks_to_tss(
  gtf_file = gtf_file,
  peaks_gr = mouse_peaks_gr,
  gene_list = c("Rag2"),
  tss_window = 100000
)

# Filter results for a specific gene
linked_peaks_gene <- linked_peaks[linked_peaks$gene_name == "Rag2", ]
}
}
