% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{predict.ocf}
\alias{predict.ocf}
\title{Prediction Method for ocf Objects}
\usage{
\method{predict}{ocf}(object, data = NULL, type = "response", ...)
}
\arguments{
\item{object}{An \code{\link{ocf}} object.}

\item{data}{Data set of class \code{data.frame}. It must contain at least the same covariates used to train the forests. If \code{data} is \code{NULL}, then \code{object$full_data} is used.}

\item{type}{Type of prediction. Either \code{"response"} or \code{"terminalNodes"}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Desired predictions.
}
\description{
Prediction method for class \code{\link{ocf}}.
}
\details{
If \code{type == "response"}, the routine returns the predicted conditional class probabilities and the predicted class 
labels. If forests are honest, the predicted probabilities are honest.\cr

If \code{type == "terminalNodes"}, the IDs of the terminal node in each tree for each observation in \code{data} are returned.\cr
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_ordered_data(100)
sample <- data$sample
Y <- sample$Y
X <- sample[, -1]

## Training-test split.
train_idx <- sample(seq_len(length(Y)), floor(length(Y) * 0.5))

Y_tr <- Y[train_idx]
X_tr <- X[train_idx, ]

Y_test <- Y[-train_idx]
X_test <- X[-train_idx, ]

## Fit ocf on training sample.
forests <- ocf(Y_tr, X_tr)

## Predict on test sample.
predictions <- predict(forests, X_test)
head(predictions$probabilities)
predictions$classification

## Get terminal nodes.
predictions <- predict(forests, X_test, type = "terminalNodes")
predictions$forest.1[1:10, 1:20] # Rows are observations, columns are forests.}

}
\references{
\itemize{
  \item Di Francesco, R. (2025). Ordered Correlation Forest. Econometric Reviews, 1–17. \doi{10.1080/07474938.2024.2429596}.
}
}
\seealso{
\code{\link{ocf}}, \code{\link{marginal_effects}}
}
\author{
Riccardo Di Francesco
}
