% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_wetlands.R
\name{nyc_wetlands}
\alias{nyc_wetlands}
\title{NYC Wetlands}
\source{
NYC Open Data: <https://data.cityofnewyork.us/dataset/NYC-Wetlands/p48c-iqtu/about_data>
}
\usage{
nyc_wetlands(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing NYC Wetlands data.
}
\description{
Downloads NYC Wetlands data from NYC Open Data.
}
\details{
This dataset includes verified and unverified wetland features that exist in New York City and
their respective locations. The columns include the wetland class of each feature, the year it
was verified (if applicable), and the feature's location, size, and shape using geospatial tools.
This dataset would be particularly useful for researchers looking to visualize NYC's wetlands
on a map, or to count the total number of features in each wetland class.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_wetlands(limit = 2)
  small_sample

  nyc_wetlands(limit = 2, filters = list(classname = "Forested"))
}
}
