% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_urban_park_animal_condition.R
\name{nyc_urban_park_animal_condition}
\alias{nyc_urban_park_animal_condition}
\title{NYC Urban Park Ranger Animal Condition Response}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/fuhs-xmg2>
}
\usage{
nyc_urban_park_animal_condition(
  limit = 10000,
  filters = list(),
  timeout_sec = 30
)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Urban Park Ranger Animal Condition Response data.
}
\description{
Downloads Urban Park Ranger Animal Condition Response data from NYC Open Data.
}
\details{
This dataset records responses by NYC Urban Park Rangers to animal-related
incidents across the five boroughs. It includes information on species,
condition, location, and outcome, helping to monitor urban wildlife trends
and public safety interactions.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_urban_park_animal_condition(limit = 2)
  small_sample

  nyc_urban_park_animal_condition(limit = 2, filters = list(age = "Infant"))
}

}
