% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bins_Mitchell2018}
\alias{bins_Mitchell2018}
\title{NMR grouping bins from Mitchell et al. (2018).}
\format{
A data frame with 7 rows and 5 variables:
\describe{
  \item{number}{Bin number}
  \item{group}{Name of bin group}
  \item{start}{ppm shift range, lower limit}
  \item{stop}{ppm shift range, upper limit}
  \item{description}{Description of the bin group}
}
}
\source{
P Mitchell et al. 2018. “Nuclear Magnetic Resonance Analysis of
Changes in Dissolved Organic Matter Composition with Successive Layering
on Clay Mineral Surfaces.” Soil Systems
\doi{10.3390/soils2010008}
}
\usage{
bins_Mitchell2018
}
\description{
NMR grouping bins from Mitchell et al. (2018), using DMSO-D6 as solvent.
(1) aliphatic polymethylene and methyl groups (0.6–1.3 ppm);
(2) N- and O-substituted aliphatic (1.3–2.9 ppm);
(3) O-alkyl (2.9–4.1 ppm);
(4) alpha-proton of peptides (4.1–4.8 ppm);
(5) anomeric proton of carbohydrates (4.8–5.2 ppm);
(6) aromatic and phenolic (6.2–7.8 ppm);
(7) amide (7.8–8.4 ppm).
}
\note{
The NMR spectrum can be split into several bins, based on
chemical shift (ppm). Binsets are specific to nuclei and solvents and
by definition are open on the left and closed on the right;
for example, a bin of (0,1) includes 1 but \emph{not} 0.
}
\seealso{
\code{\link{bins_Clemente2012}} \code{\link{bins_Lynch2019}}
\code{\link{bins_Hertkorn2013}}
}
\keyword{datasets}
