% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learners.R
\name{lnr_gam}
\alias{lnr_gam}
\title{Generalized Additive Model Learner}
\usage{
lnr_gam(data, formula, weights = NULL, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
A prediction function that accepts \code{newdata},
which returns predictions (a numeric vector of values, one for each row
of \code{newdata}).
}
\description{
A wrapper for \code{mgcv::gam()} for use in \code{nadir::super_learner()}.
}
\examples{
lnr_gam(mtcars, mpg ~ s(hp) + disp + am + wt)(mtcars)
lnr_gam(mtcars, mpg ~ s(hp) + disp + am + wt, family = Gamma)(mtcars)
}
\seealso{
learners
}
