% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{table2df}
\alias{table2df}
\title{Table Mutation Types by Sample.}
\usage{
table2df(dataMatrix, rowLab = "sample", colLab = "feature", valueLab = "count")
}
\arguments{
\item{dataMatrix}{a numeric matrix including mutation counts}

\item{rowLab}{string, name for the column that will be storing row IDs, typically sample IDs}

\item{colLab}{string, name for the column that will be storing column IDs, typically sample IDs}

\item{valueLab}{string, name for the column that will be storing mutation count values}
}
\value{
data.frame storing mutation counts by sample
}
\description{
Prepare a molten data.frame starting from a mutation count matrix.
Mutation types (rows) are countes for each sample (cols). The results are returned in a
3-column data.frame.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
A <- cbind(`A>G`=c(5,10),`A>T`=c(3,20),`A>C`=c(15,0))
rownames(A) = c("Smpl1", "Smpl2")
mutSignatures::table2df(A)

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
