% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{silhouetteMLB}
\alias{silhouetteMLB}
\title{Silhouette Analysis.}
\usage{
silhouetteMLB(data, fac, method = "cosine", plot = TRUE)
}
\arguments{
\item{data}{numeric matrix}

\item{fac}{clustering factor}

\item{method}{method to be used as distance function. Defaults to c("cosine")}

\item{plot}{logical, shall a barplot showing the cluster silhouettes be printed}
}
\value{
numeric vector including the silhouette values of the data poointts in the input matrix
}
\description{
Analyze the clustering quality and generate a Silhouette Plot.
}
\examples{
library(mutSignatures)
x <- mutSignatures:::getTestRunArgs("silhouetteMLB")
y <- silhouetteMLB(data = x$data, fac = x$fac)
y

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item \bold{Silhouette analysis in R}: \url{http://www.biotechworld.it/bioinf/2017/01/20/translating-matlabs-silhouette-function-to-r/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
