% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{extractXvarlinkData}
\alias{extractXvarlinkData}
\title{Extract Variants from XvarlinkData.}
\usage{
extractXvarlinkData(xvarLink_data)
}
\arguments{
\item{xvarLink_data}{character vector, including mutation data embedded in XvarlinkData}
}
\value{
a data.frame including mutations as well as corresponding reference nucleotides.
}
\description{
Extract Variants from data stored as XvarlinkData.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
x <- mutSignatures:::getTestRunArgs("extractXvarlinkData")
y <- mutSignatures:::extractXvarlinkData(xvarLink_data = x)
y

            
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
