% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-examples.R
\name{example_ndmm}
\alias{example_ndmm}
\title{Example newly-diagnosed multiple myeloma}
\description{
Calling \code{example("example_ndmm")} will run a proportional
hazards Weibull NMA model on the newly-diagnosed multiple myeloma data,
using the code in the Examples section below. The resulting \code{stan_nma}
object \code{ndmm_fit} will then be available in the global environment.
}
\examples{
# Set up newly-diagnosed multiple myeloma network

head(ndmm_ipd)
head(ndmm_agd)

ndmm_net <- combine_network(
  set_ipd(ndmm_ipd,
          study, trt,
          Surv = Surv(eventtime / 12, status)),
  set_agd_surv(ndmm_agd,
               study, trt,
               Surv = Surv(eventtime / 12, status),
               covariates = ndmm_agd_covs))
\donttest{
# Fit Weibull (PH) model
ndmm_fit <- nma(ndmm_net, 
                likelihood = "weibull",
                prior_intercept = normal(scale = 100),
                prior_trt = normal(scale = 10),
                prior_aux = half_normal(scale = 10))

ndmm_fit
}
\dontshow{
if (requireNamespace("pkgdown", quietly = TRUE) && pkgdown::in_pkgdown()) {
  assign("ndmm_net", ndmm_net, .GlobalEnv)
  assign("ndmm_fit", ndmm_fit, .GlobalEnv)
}
}
}
\keyword{examples}
