% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dat_unmarked.R
\name{sim_dat_unmarked}
\alias{sim_dat_unmarked}
\title{Simulate data for optimizing scales of effect with `unmarked`}
\usage{
sim_dat_unmarked(
  alpha = 1,
  beta = NULL,
  kernel = c("gaussian", "exp", "expow", "fixed"),
  type = c("count", "count_nb", "occ"),
  StDev = 0.5,
  n_points = 50,
  n_surv = 3,
  det = 0.5,
  min_D = NULL,
  raster_stack = NULL,
  sigma = NULL,
  shape = NULL,
  max_D = NULL,
  user_seed = NULL,
  ...
)
}
\arguments{
\item{alpha}{Intercept term for GLM (Default = 1)}

\item{beta}{Slope term(s) for GLM. Should be vector equal in length to number of spatRaster surfaces provided}

\item{kernel}{Type of kernel transformation. Valid options are 'gaussian', 'exp' (negative exponential), 'expow' (exponential power), and 'fixed' fixed width buffer. (Default = 'gaussian')}

\item{type}{Type of response data to simulate in `unmarked`. Valid options are 'count' for Poisson distributed count; 'count_nb' for negative binomial counts; and 'occ' for binomial response.(Default = 'count')}

\item{StDev}{If specifying 'count_nb' or 'gaus' for type, this is the dispersion term for those respective processes (Default = 0.5)}

\item{n_points}{Number of spatial sample points (Default = 50).}

\item{n_surv}{Number of surveys to simulate in `unmarked` (Default = 3).}

\item{det}{The probability of detection. (Default = 0.5)}

\item{min_D}{Minimum distance between points. Function will attempt to create the number of sample points specified while honoring this minimum distance.}

\item{raster_stack}{A spatRaster object}

\item{sigma}{The scale term dictating the rate of decay with distance}

\item{shape}{If using an exponential power function, the shape parameter must also be specified. Values between 1-50 are generally valid}

\item{max_D}{The maximum distance surrounding spatial points to consider. This typically needs to be >= 2.5x greater than sigma}

\item{user_seed}{Optional seed to reproduce simulation}

\item{...}{Additional arguments. Not currently used}
}
\value{
Returns a list containing:
\tabular{ll}{
\tab * y --> The simulated observation matrix for use in an unmarkedFrame \cr
\tab * df --> A data frame with the simulated response (obs) as well as the true kernel weighted mean values for each raster surface included \cr
\tab * pts --> An `sf` object with the simulated spatial point locations \cr
  }
}
\description{
Function to simulate data with known scales of effect from spatial spatRaster variables for analysis with the R package `unmarked`
}
\details{
This function distributes sample points across the landscape on a hexagonal grid, then subsamples to the specified number. The weighted values of each landscape are determined according to the simulation parameters, then the specified response is generated.
}
\examples{
\donttest{
rs <- sim_rast(user_seed = 123)
rs <- terra::subset(rs, c(1,3))
s_dat <- sim_dat_unmarked(alpha = 1,
                          beta = c(0.75,-0.75),
                          kernel = 'gaussian',
                          sigma = c(75, 150),
                          n_points = 75,
                          n_surv = 5,
                          det = 0.5,
                          type = 'count',
                          raster_stack = rs,
                          max_D = 550,
                          user_seed = 123)
plot(s_dat$df$y ~ s_dat$df$bin1)
plot(s_dat$df$y ~ s_dat$df$cont1)
## unmarked analysis
library(unmarked)
kernel_inputs <- kernel_prep(pts = s_dat$pts,
                             raster_stack = rs,
                             max_D = 550,
                             kernel = 'gaus')

umf <- unmarkedFramePCount(y = s_dat$y,
                           siteCovs = kernel_inputs$kernel_dat)

## Base unmarked model
mod0 <- pcount(~1 ~bin1 + cont1,
               data = umf,
               K = 100)

## `multiscale_optim`
opt1 <- multiScale_optim(fitted_mod = mod0,
                         kernel_inputs = kernel_inputs)

summary(opt1)
}
}
