% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_RNN.R
\name{engine_RNN}
\alias{engine_RNN}
\title{The Engine of Recurrent Neural Network (RNN)}
\usage{
engine_RNN(
  data,
  colnames,
  behrule,
  model,
  funcs = NULL,
  priors,
  settings = NULL,
  control = control,
  ...
)
}
\arguments{
\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{model}{Reinforcement Learning Model}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{control}{Settings manage various aspects of the iterative process,
see \link[multiRL]{control}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A specialized TensorFlow-trained Recurrent Neural Network (RNN) object.
 The model can be used with the \code{predict()} function to make predictions 
 on a new data frame, estimating the input parameters that are most likely 
 to have generated the given dataset.
}
\description{
Because TensorFlow requires numeric arrays and input parameters to learn 
   the mapping between them when building a Recurrent Neural Network (RNN) 
   model, this function transforms simulated data into a standardized 
   dataset and invokes TensorFlow to train the model.
}
