% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubramanianTest.R
\docType{class}
\name{SubramanianTest-class}
\alias{SubramanianTest-class}
\alias{SubramanianTest}
\alias{run_test,SubramanianTest-method}
\title{PRIVATE class : An S4 class to represent a ranked based tests in mulea.}
\usage{
\S4method{run_test}{SubramanianTest}(model)
}
\arguments{
\item{model}{Object of s4 class represents mulea Test.}
}
\value{
\code{data.frame} with presented columns 'ontology_id', 'ontology_name',
'nr_common_with_tested_elements',
'p_value', 'adjusted_p_value'

run_test method for SubramanianTest object. Used as private
function.
}
\description{
PRIVATE class : An S4 class to represent a ranked based tests in mulea.
}
\section{Methods (by generic)}{
\itemize{
\item \code{run_test(SubramanianTest)}: runs test calculations.

}}
\section{Slots}{

\describe{
\item{\code{gmt}}{A \code{data.frame} representing the ontology GMT.}

\item{\code{element_names}}{A vector of elements names (gene or protein names or
identifiers) to include in the analysis.}

\item{\code{element_scores}}{A vector of numeric values representing a
score (\emph{e.g.} \emph{p}-value, \emph{z}-score, log fold change) for each
'element_name', in the same number and order as element_name.}

\item{\code{p}}{A power of weight.}

\item{\code{element_score_type}}{Defines the GSEA score type.
\itemize{
\item "pos": Only positive element_scores
\item "neg": only negative element_scores - "neg" and mixed
\item "std": standard -- containing both positive and negative scores
Default value is "std".
}}
}}

