% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_mtsta_distribution.R
\name{search_mtsta_distribution}
\alias{search_mtsta_distribution}
\title{Search Species Distribution of A Regional Red List of Montane Tree Species of the Tropical Andes}
\usage{
search_mtsta_distribution(splist, max_distance = 0.1, typedf = "main")
}
\arguments{
\item{splist}{Character vector of submitted plant species names for which distribution
data is to be searched.}

\item{max_distance}{Numeric value representing the maximum allowed distance for approximate
string matching. The default value is 0.1.}

\item{typedf}{"main" return a selected columns in from mtsta_distribution
"full" return all data}
}
\value{
A data frame with the following columns:
\describe{
\item{name_submitted}{Character vector with the submitted species names.}
\item{name_matched}{Character vector with the matched species names in the database.}
\item{accepted_name}{Character vector with the accepted names of the matched species.}
\item{distribution}{Character vector with the distribution of the matched species.}
\item{unsure_distribution}{Character vector with information about unsure distribution (if available).}
\item{distribution_wcvp}{Character vector with the distribution from the World Check-list
of Vascular Plants (WCVP) database for the matched species.}
\item{taxonomic_status}{Character vector indicating the taxonomic status of the matched species.}
\item{distance}{Numeric vector with the Levenshtein distance between submitted and matched species names.}
}
}
\description{
This function searches the Montane Tree Species of the Tropical Andes distribution
database for a list of submitted species names and returns their distribution information.
The search allows for approximate string matching within a given maximum distance.
}
\details{
The function uses approximate string matching with a maximum distance specified by
the \code{max_distance} argument. It searches the \code{mtsta} distribution database for submitted
species names that match the provided names within the given distance. The function then
retrieves distribution information, including the accepted name, distribution region, unsure
distribution (if available), distribution from the World Check-list of Vascular Plants (WCVP),
taxonomic status, and the Levenshtein distance between submitted and matched species names.
}
\examples{
# Example usage of search_mtsta_distribution function
species_list <- c("Escallonia mirtilloydes", "Ilex rimbachii", "Saurauia lehmannii")
distribution_data <- search_mtsta_distribution(species_list, max_distance = 0.2)
print(distribution_data)

}
\seealso{
\code{\link[mtsta]{mtsta_distribution}}
}
