% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtsta_search.R
\name{search_mtsta}
\alias{search_mtsta}
\title{Search for Matching Species Names in the Red List of Montane Tree Species of
the Tropical Andes}
\usage{
search_mtsta(splist, max_distance = 0.1, ...)
}
\arguments{
\item{splist}{A character vector containing the species names to be matched.}

\item{max_distance}{The distance used is a generalized Levenshtein distance that indicates
the total number of insertions, deletions, and substitutions allowed to
match the two names. It can be expressed as an integer or as the fraction of
the binomial name.
A value between 0 and 1 will be treated as a percentage of the string length.
A value greater than 1 will be treated as an absolute number of allowed changes.
For example, a name with length 10, and a max_distance = 0.1, allow only one
change (insertion, deletion, or substitution). A max_distance = 2, allows two changes.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{name_submitted}: The submitted species names.
\item \code{name_matched}: The matched species names from the mtsta data.
\item \code{accepted_name}: The accepted scientific name of the matched species.
\item \code{accepted_family}: The accepted family name of the matched species.
\item \code{accepted_genus}: The accepted genus name of the matched species.
\item \code{taxonomic_status}: The taxonomic status of the matched species.
\item \code{iucn}: The conservation status of the matched species according to the IUCN Red List Categories.
\item \code{distribution}: The distribution range of the matched species.
\item \code{unsure_distribution}: Information about the uncertainty in the distribution data.
\item \code{elevation}: The elevation range where the species is found.
\item \code{assessor}: The person or group responsible for assessing the species.
\item \code{description}: Additional information or description of the species.
\item \code{distance}: The Levenshtein distance between the submitted name and the matched name.
}
If no match is found, the \code{name_matched} column will contain "nill",
and the other columns will be empty.
}
\description{
This function searches for matching species names in the Red List of Montane
Tree Species of the Tropical Andes (\code{mtsta} package) based on a provided
list of species names. The function performs approximate matching using the
Levenshtein distance algorithm to find similar names within a specified
maximum distance.
}
\examples{
# Assuming you have the mtsta package loaded with the necessary data
search_result <- search_mtsta(c("Aphelandra acantasa",
                                "Saurauia lehmani",
                                "Saurauia bullosaa",
                                "Schinus meyerii",
                                "Ilex colombiana",
                                "Ilex rimbachii",
                                "Ilex scopulorum"),
                              max_distance = 0.1)

}
\seealso{
\code{mtsta::mtsta_tab}
}
