% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{annotatemrbin}
\alias{annotatemrbin}
\title{A function for annotating mrbin objects.}
\usage{
annotatemrbin(
  mrbinObject,
  annotate = TRUE,
  binwidth = 0.01,
  binheight = 1,
  dimension = "1D",
  metaboliteIdentities = NULL,
  add = FALSE,
  hideChemicalShift = FALSE,
  includeAll = FALSE,
  maxMetabolites = NULL,
  batchSize = 50,
  tiers = c(1, 2, 4, 5),
  peakRatio = c(0.67, 0.4, 0),
  Rmodifier = NULL,
  confirmationRthreshold = c(0.89, 0.84, 0.82),
  peakRthreshold = NULL,
  showMissing = FALSE,
  exclude = NULL,
  expandRange = 0,
  expandRangeFactor = 15,
  verbose = TRUE
)
}
\arguments{
\item{mrbinObject}{An mrbin object or matrix of bin intensities. In case of a matrix, the row names can be in the format left border, right border ("1.22,1.21") or the center of the bin ("1.215"). In the latter case, the parameters binwidth (and binheight if required) should be chosen accordingly. For 2D data, this would be "1.22,1.21,35,36" or "1.215,35.5"}

\item{annotate}{If FALSE, the mrbin object will not be changed.}

\item{binwidth}{Full width of each bin. Will only be used if mrbinObject is a matrix}

\item{binheight}{Full height of each bin. Will only be used if mrbinObject is a matrix and dimension is set to "2D"}

\item{dimension}{Dimension of NMR data set, option are "1D" or "2D" (e.g. for HSQC data). Will only be used if mrbinObject is a matrix}

\item{metaboliteIdentities}{A numeric matrix or the file path for a .csv file containing such a matrix, the first columns containing metabolite names and the first row being a header. Each row belongs to one unique metabolite signal (left, right, top, bottom borders). Row names are metabolite names. If provided, this will overwrite any current metaboliteIdentities matrix present in the mrbin object. If missing, data currently attached to the mrbin object (if any) will be used.}

\item{add}{Should the new metabolite list be added to an existing list, or replace the current list?}

\item{hideChemicalShift}{Should the chemical shift (bin borders) of an identified metabolite be removed, leaving only the metabolite id, or should both be shown? Showing both helps in identifying signals of interest, but hiding the chemical shift might make better plots.}

\item{includeAll}{Should all metabolites in the predefined list be used, even if they aren't in the ordered list for this sample matrix?}

\item{maxMetabolites}{Maximum number of metabolites to be used. Default is NULL (all metabolites in the list will be used)}

\item{batchSize}{Look for this number of top metabolites first, then move n the next batch of lower-abundance metabolites}

\item{tiers}{Should all tiers (1 through 5) of identification be applied? .}

\item{peakRatio}{A threshold for the minimum ratio of significant peaks to total peaks to confirm an annotation}

\item{Rmodifier}{A number by which the confirmationRthreshold is multiplied. This can be used to lower R threshold when signal-to-noise levels are low, such as in 2D spectra. If set to NULL (default), this will use 1 for 1D spectra and 0.4 for 2D spectra}

\item{confirmationRthreshold}{A threshold to define the r-value cutoff to confirm an annotation}

\item{peakRthreshold}{A threshold to define the r-value cutoff that bins within one peak need to show to the first identified bin of the peak to be considered. If NULL, this will use .8 for 1D and .2 for 2D}

\item{showMissing}{Should metabolites missing from the peak database be shown}

\item{exclude}{Exclude specific metbolites from annotation, e.g. "DSS" if TSP was used instead.}

\item{expandRange}{Expand the search range by this value in ppm. This could be used for low-field spectra.}

\item{expandRangeFactor}{The expandRange will be multiplied by this value for the second, indirect dimension, e.g 13C.}

\item{verbose}{Should outputs be shown or suppressed?}
}
\value{
An (invisible) mrbin object
}
\description{
This function annotates an mrbin object and returns it with updated $annotations vector
}
\examples{
resetEnv()#clean up previous data from the package environment 
results<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.04,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,0.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,
                   NMRvendor="mrbin",
                   example=TRUE,#only used for the package examples
                   NMRfolders=c(system.file("extdata/3.mr1",package="mrbin"),
                              system.file("extdata/2.mr1",package="mrbin"),
                              system.file("extdata/1.mr1",package="mrbin"))))
metaboliteIdentities=matrix(c(1.346,1.324,21,23,1,1,
                              3.052,3.043,30.5,33.5,1,1),
                   ncol=6,byrow=TRUE)
rownames(metaboliteIdentities)=c("Lactate","Creatinine")
colnames(metaboliteIdentities)=c("left","right","top","bottom","usePeak1D","usePeak2D")
results<-annotatemrbin(results,metaboliteIdentities=metaboliteIdentities)
results$metadata$annotations[150:160]
plotPCA(results,loadings=TRUE)
}
