% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{confusion}
\alias{confusion}
\alias{confusion.default}
\alias{confusion.mlearning}
\alias{print.confusion}
\alias{summary.confusion}
\alias{print.summary.confusion}
\title{Construct and analyze confusion matrices}
\usage{
confusion(x, ...)

\method{confusion}{default}(
  x,
  y = NULL,
  vars = c("Actual", "Predicted"),
  labels = vars,
  merge.by = "Id",
  useNA = "ifany",
  prior,
  ...
)

\method{confusion}{mlearning}(
  x,
  y = response(x),
  labels = c("Actual", "Predicted"),
  useNA = "ifany",
  prior,
  ...
)

\method{print}{confusion}(x, sums = TRUE, error.col = sums, digits = 0, sort = "ward.D2", ...)

\method{summary}{confusion}(object, type = "all", sort.by = "Fscore", decreasing = TRUE, ...)

\method{print}{summary.confusion}(x, ...)
}
\arguments{
\item{x}{an object with a \code{confusion()} method implemented.}

\item{...}{further arguments passed to the method.}

\item{y}{another object, from which to extract the second classification, or
\code{NULL} if not used.}

\item{vars}{the variables of interest in the first and second classification
in the case the objects are lists or data frames. Otherwise, this argument
is ignored and \code{x} and \code{y} must be factors with same length and same levels.}

\item{labels}{labels to use for the two classifications. By default, they are
the same as \code{vars}, or the one in the confusion matrix.}

\item{merge.by}{a character string with the name of variables to use to merge
the two data frames, or \code{NULL}.}

\item{useNA}{do we keep \code{NA}s as a separate category? The default \code{"ifany"}
creates this category only if there are missing values. Other possibilities
are \code{"no"}, or \code{"always"}.}

\item{prior}{class frequencies to use for first classifier that is tabulated
in the rows of the confusion matrix. For its value, see here under, the
\verb{value=} argument.}

\item{sums}{is the confusion matrix printed with rows and columns sums?}

\item{error.col}{is a column with class error for first classifier added
(equivalent to false negative rate of FNR)?}

\item{digits}{the number of digits after the decimal point to print in the
confusion matrix. The default or zero leads to most compact presentation
and is suitable for frequencies, but not for relative frequencies.}

\item{sort}{are rows and columns of the confusion matrix sorted so that
classes with larger confusion are closer together? Sorting is done
using a hierarchical clustering with \code{\link[=hclust]{hclust()}}. The clustering method
is \code{"ward.D2"} by default, but see the \code{\link[=hclust]{hclust()}} help for other options).
If \code{FALSE} or \code{NULL}, no sorting is done.}

\item{object}{a \strong{confusion} object}

\item{type}{either \code{"all"} (by default), or considering \code{TP} is the true
positives, \code{FP} is the false positives, \code{TN} is the true negatives and \code{FN}
is the false negatives, one can also specify: \code{"Fscore"} (F-score = F-measure
= F1 score = harmonic mean of Precision and recall), \code{"Recall"}
(TP / (TP + FN) = 1 - FNR), \code{"Precision"} (TP / (TP + FP) = 1 - FDR),
\code{"Specificity"} (TN / (TN + FP) = 1 - FPR), \code{"NPV"} (Negative predicted value
= TN / (TN + FN) = 1 - FOR), \code{"FPR"} (False positive rate = 1 - Specificity
= FP / (FP + TN)), \code{"FNR"} (False negative rate = 1 - Recall = FN / (TP + FN)),
\code{"FDR"} (False Discovery Rate = 1 - Precision = FP / (TP + FP)), \code{"FOR"}
(False omission rate = 1 - NPV = FN / (FN + TN)), \code{"LRPT"} (Likelihood Ratio
for Positive Tests = Recall / FPR = Recall / (1 - Specificity)), \code{"LRNT"}
Likelihood Ratio for Negative Tests = FNR / Specificity = (1 - Recall) /
Specificity, \code{"LRPS"} (Likelihood Ratio for Positive Subjects = Precision /
FOR = Precision / (1 - NPV)), \code{"LRNS"} (Likelihood Ratio Negative Subjects =
FDR / NPV = (1 - Precision) / (1 - FOR)), \code{"BalAcc"} (Balanced accuracy
= (Sensitivity + Specificity) / 2), \code{"MCC"} (Matthews correlation coefficient),
\code{"Chisq"} (Chisq metric), or \code{"Bray"} (Bray-Curtis metric)}

\item{sort.by}{the statistics to use to sort the table (by default, Fmeasure,
the F1 score for each class = 2 * recall * precision / (recall + precision)).}

\item{decreasing}{do we sort in increasing or decreasing order?}
}
\value{
A confusion matrix in a \strong{confusion} object.
}
\description{
Confusion matrices compare two classifications (usually one done
automatically using a machine learning algorithm versus the true
classification done by a specialist... but one can also compare two automatic
or two manual classifications against each other).
}
\examples{
data("Glass", package = "mlbench")
# Use a little bit more informative labels for Type
Glass$Type <- as.factor(paste("Glass", Glass$Type))

# Use learning vector quantization to classify the glass types
# (using default parameters)
summary(glass_lvq <- ml_lvq(Type ~ ., data = Glass))

# Calculate cross-validated confusion matrix
(glass_conf <- confusion(cvpredict(glass_lvq), Glass$Type))
# Raw confusion matrix: no sort and no margins
print(glass_conf, sums = FALSE, sort = FALSE)

summary(glass_conf)
summary(glass_conf, type = "Fscore")
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=plot.confusion]{plot.confusion()}}, \code{\link[=prior]{prior()}}
}
