# `build_fm()`, `kfm_exact()`, `kfm_nystrom()` examples work

    Code
      df <- data.frame(X1 = c(2, 3, 4, 5, 6, 7, 8), X2 = c(1, 1.2, 1.3, 1.4, 1.1, 7,
        1), X3 = rnorm(7))
      fit1 <- kfm_nystrom(df, m = 7, r = 6, kernel = "radial", sigma = 0.05)
      fm <- build_fm(fit1, df)
      fit2 <- kfm_exact(kernel = "polynomial", degree = 2, const = 1)
      fm <- build_fm(fit2, df)

# `generate_mild_df()` examples work

    Code
      set.seed(8)
      mild_data <- generate_mild_df(nbag = 7, ninst = 3, nsample = 20, ncov = 2,
        nimp_pos = 1, dist = rep("mvnormal", 3), mean = list(rep(5, 1), rep(15, 2), 0))
      dplyr::distinct(mild_data, bag_label, bag_name, instance_name)
    Output
      # An MILD data frame: 21 x 3 with 7 bags, 21 instances
      # and instance labels: 0, 0, 0, 0, 0, ...
         bag_label bag_name instance_name
             <dbl> <chr>    <chr>        
       1         0 bag1     bag1inst1    
       2         0 bag1     bag1inst2    
       3         0 bag1     bag1inst3    
       4         0 bag2     bag2inst1    
       5         0 bag2     bag2inst2    
       6         0 bag2     bag2inst3    
       7         1 bag3     bag3inst1    
       8         1 bag3     bag3inst2    
       9         1 bag3     bag3inst3    
      10         0 bag4     bag4inst1    
      # i 11 more rows
    Code
      split(mild_data[, 4:5], mild_data$instance_name) %>% sapply(colMeans) %>% round(
        2) %>% t()
    Warning <rlang_warning>
      Dropping 'mild_df' class as required column was removed.
    Output
                   X1    X2
      bag1inst1 14.95 14.63
      bag1inst2 15.53 15.42
      bag1inst3 14.27 16.08
      bag2inst1 15.29 15.01
      bag2inst2 15.78 14.87
      bag2inst3 14.53 15.71
      bag3inst1 14.79 14.83
      bag3inst2  5.36 -0.69
      bag3inst3 15.13 15.78
      bag4inst1 15.32 14.46
      bag4inst2 15.31 15.53
      bag4inst3 15.93 14.55
      bag5inst1 15.25 14.25
      bag5inst2 14.98 16.03
      bag5inst3 15.48 14.95
      bag6inst1  4.83  0.26
      bag6inst2 16.23 16.06
      bag6inst3 15.31 14.56
      bag7inst1 14.74 14.90
      bag7inst2 14.61 15.03
      bag7inst3 15.17 15.20

# `kme()` examples work

    Code
      x = data.frame(instance_name = c("inst_1", "inst_2", "inst_1"), X1 = c(-0.4,
        0.5, 2))
      kme(x)
    Output
                [,1]      [,2]
      [1,] 0.8748808 0.9269533
      [2,] 0.9269533 1.0000000
    Code
      mild_df1 <- generate_mild_df(nbag = 10, positive_degree = 3)
      kme(mild_df1)
    Output
                 [,1]      [,2]      [,3]      [,4]      [,5]      [,6]      [,7]
       [1,] 0.4169122 0.3523994 0.2999620 0.3919451 0.2671537 0.3808291 0.3178319
       [2,] 0.3523994 0.4001522 0.3488563 0.3862459 0.3258604 0.3828253 0.3553224
       [3,] 0.2999620 0.3488563 0.3830298 0.3729092 0.3410245 0.3829949 0.3563669
       [4,] 0.3919451 0.3862459 0.3729092 0.6736729 0.3829977 0.4622801 0.3786055
       [5,] 0.2671537 0.3258604 0.3410245 0.3829977 0.3866819 0.3438624 0.3125532
       [6,] 0.3808291 0.3828253 0.3829949 0.4622801 0.3438624 0.5928032 0.3992530
       [7,] 0.3178319 0.3553224 0.3563669 0.3786055 0.3125532 0.3992530 0.4072973
       [8,] 0.2886348 0.3157459 0.2987742 0.3711378 0.2682204 0.3401411 0.2749737
       [9,] 0.3872634 0.4011600 0.3740848 0.4325844 0.3109014 0.4722626 0.3594980
      [10,] 0.3086363 0.3301951 0.2900993 0.3880930 0.2750935 0.3674942 0.3147702
      [11,] 0.3300471 0.3715490 0.3490256 0.3765055 0.3468922 0.3911776 0.3134912
      [12,] 0.3496296 0.3733415 0.3661626 0.5378319 0.3513647 0.4593275 0.3566796
      [13,] 0.2643695 0.3083248 0.3592159 0.3650698 0.3075189 0.3443388 0.3521353
      [14,] 0.3510899 0.3496693 0.3579273 0.4438735 0.3136538 0.4244626 0.3410867
      [15,] 0.3306274 0.3505787 0.3460770 0.4034540 0.3067107 0.4154028 0.3552658
      [16,] 0.3547158 0.3407101 0.3166309 0.3790609 0.2549436 0.3913973 0.3093184
      [17,] 0.3413221 0.3310640 0.3056185 0.4769570 0.2984654 0.3205515 0.3010842
      [18,] 0.3385712 0.3715150 0.3362378 0.3772033 0.3236153 0.3631170 0.3673017
      [19,] 0.3274643 0.3157874 0.3209078 0.3923291 0.2950952 0.3912085 0.3039875
      [20,] 0.3024896 0.3319636 0.3544274 0.3987057 0.3375483 0.4542176 0.3624589
      [21,] 0.3037886 0.3305133 0.3058440 0.4023323 0.2933122 0.3999505 0.3038551
      [22,] 0.4046782 0.4063992 0.3687206 0.4748479 0.3561605 0.5333569 0.3857608
      [23,] 0.2921442 0.3529623 0.2947198 0.3825395 0.2826722 0.3598854 0.2964741
      [24,] 0.3670381 0.3722187 0.3556825 0.4504677 0.3279440 0.4540149 0.3728457
      [25,] 0.3293533 0.3842095 0.3365811 0.3505797 0.3083936 0.3654656 0.3492568
      [26,] 0.4514919 0.4317108 0.3776675 0.5362912 0.3806510 0.4668916 0.3974679
      [27,] 0.3072870 0.3522197 0.3407901 0.4046125 0.3505049 0.3589900 0.3183809
      [28,] 0.3351851 0.3453512 0.3313021 0.4664949 0.3088645 0.4280774 0.3465275
      [29,] 0.4277095 0.3869842 0.3158980 0.4345843 0.2831570 0.3771593 0.3238047
      [30,] 0.3918940 0.4233512 0.3803228 0.5079662 0.3517907 0.4494309 0.3917467
      [31,] 0.3209992 0.3356011 0.3067535 0.3937972 0.2606738 0.3971114 0.3341408
      [32,] 0.3304344 0.3615479 0.3098770 0.3813640 0.3323581 0.3808892 0.3229543
      [33,] 0.3633943 0.3933628 0.4126571 0.4078071 0.3401322 0.4569400 0.3942821
      [34,] 0.3187196 0.3354348 0.3444837 0.4187835 0.3351518 0.3974189 0.3215929
      [35,] 0.3067201 0.3295164 0.3086434 0.4358080 0.2989232 0.3744900 0.3193445
      [36,] 0.3709173 0.3094088 0.2352705 0.3380354 0.2257843 0.3056635 0.2402585
      [37,] 0.3747756 0.3482068 0.3025652 0.4241205 0.2659261 0.4055969 0.3187351
      [38,] 0.3645088 0.3434428 0.3443278 0.3946202 0.2756704 0.4240096 0.3299400
      [39,] 0.3080024 0.3640326 0.3355290 0.3848462 0.2924023 0.3766813 0.3508378
      [40,] 0.4362794 0.4125146 0.3767652 0.4305746 0.3363838 0.4993309 0.3431162
                 [,8]      [,9]     [,10]     [,11]     [,12]     [,13]     [,14]
       [1,] 0.2886348 0.3872634 0.3086363 0.3300471 0.3496296 0.2643695 0.3510899
       [2,] 0.3157459 0.4011600 0.3301951 0.3715490 0.3733415 0.3083248 0.3496693
       [3,] 0.2987742 0.3740848 0.2900993 0.3490256 0.3661626 0.3592159 0.3579273
       [4,] 0.3711378 0.4325844 0.3880930 0.3765055 0.5378319 0.3650698 0.4438735
       [5,] 0.2682204 0.3109014 0.2750935 0.3468922 0.3513647 0.3075189 0.3136538
       [6,] 0.3401411 0.4722626 0.3674942 0.3911776 0.4593275 0.3443388 0.4244626
       [7,] 0.2749737 0.3594980 0.3147702 0.3134912 0.3566796 0.3521353 0.3410867
       [8,] 0.3827260 0.3907545 0.2988163 0.3308321 0.3751270 0.2927895 0.3424322
       [9,] 0.3907545 0.5245163 0.3503800 0.3956145 0.4558087 0.3169918 0.4143504
      [10,] 0.2988163 0.3503800 0.3778166 0.3133673 0.3854424 0.2845932 0.3253879
      [11,] 0.3308321 0.3956145 0.3133673 0.4192976 0.3827056 0.3105342 0.3439707
      [12,] 0.3751270 0.4558087 0.3854424 0.3827056 0.5381580 0.3410197 0.4040592
      [13,] 0.2927895 0.3169918 0.2845932 0.3105342 0.3410197 0.4152752 0.3384331
      [14,] 0.3424322 0.4143504 0.3253879 0.3439707 0.4040592 0.3384331 0.4227283
      [15,] 0.3529021 0.4052576 0.3318198 0.3378625 0.3899277 0.3435705 0.3792346
      [16,] 0.3247552 0.4200867 0.3237023 0.3466853 0.3903709 0.3004923 0.3533612
      [17,] 0.3023912 0.3428421 0.3114730 0.3110601 0.3819310 0.3000919 0.3629485
      [18,] 0.2923464 0.3394161 0.3164056 0.3531750 0.3375635 0.3346717 0.3247464
      [19,] 0.2713716 0.3836950 0.2482132 0.3223733 0.3761191 0.2686236 0.3305258
      [20,] 0.2857859 0.3744232 0.3174561 0.3395988 0.3984483 0.3315578 0.3550107
      [21,] 0.2627253 0.3836853 0.2795323 0.3301624 0.3831656 0.2488448 0.3148869
      [22,] 0.3406292 0.4621339 0.3923090 0.3955028 0.4495619 0.3141189 0.4283485
      [23,] 0.3157345 0.3856858 0.3494546 0.3538506 0.3917857 0.2697028 0.3082309
      [24,] 0.3275562 0.4251279 0.3382506 0.3577489 0.4262159 0.3256938 0.3830319
      [25,] 0.3231252 0.3904057 0.3485463 0.3771474 0.3788117 0.3159366 0.3161134
      [26,] 0.3373112 0.4363885 0.4001063 0.4178917 0.4635879 0.3431673 0.4212106
      [27,] 0.3388433 0.3562988 0.3225072 0.3660954 0.3718644 0.3297816 0.3608778
      [28,] 0.2935088 0.3908359 0.3247119 0.3233924 0.4104011 0.3010204 0.3750590
      [29,] 0.3255437 0.4056847 0.3709777 0.3798311 0.3901575 0.3028651 0.3793250
      [30,] 0.3773517 0.4505271 0.4349212 0.4046103 0.4724630 0.3729573 0.4305713
      [31,] 0.3151219 0.4048709 0.3019086 0.2964317 0.3670353 0.2776221 0.3516817
      [32,] 0.3101098 0.3605160 0.3237806 0.3617166 0.3625330 0.2743012 0.3224096
      [33,] 0.3271257 0.4471554 0.3090527 0.3839613 0.3851377 0.3774804 0.4184469
      [34,] 0.3434242 0.3851384 0.2983263 0.3592944 0.3967367 0.3314950 0.3647405
      [35,] 0.3355117 0.3918822 0.3211793 0.3102746 0.4325159 0.2788364 0.3399177
      [36,] 0.2370985 0.3357440 0.2703925 0.2874996 0.2988993 0.1794404 0.2905320
      [37,] 0.3102639 0.4125572 0.3560512 0.3232770 0.4074992 0.2703437 0.3675738
      [38,] 0.3191465 0.4189078 0.3061028 0.3536871 0.3836219 0.3285568 0.3830229
      [39,] 0.3091127 0.3884269 0.3297345 0.3310730 0.3640645 0.3208774 0.3476835
      [40,] 0.3742521 0.5217239 0.3386285 0.4284365 0.4327775 0.2919186 0.4346810
                [,15]     [,16]     [,17]     [,18]     [,19]     [,20]     [,21]
       [1,] 0.3306274 0.3547158 0.3413221 0.3385712 0.3274643 0.3024896 0.3037886
       [2,] 0.3505787 0.3407101 0.3310640 0.3715150 0.3157874 0.3319636 0.3305133
       [3,] 0.3460770 0.3166309 0.3056185 0.3362378 0.3209078 0.3544274 0.3058440
       [4,] 0.4034540 0.3790609 0.4769570 0.3772033 0.3923291 0.3987057 0.4023323
       [5,] 0.3067107 0.2549436 0.2984654 0.3236153 0.2950952 0.3375483 0.2933122
       [6,] 0.4154028 0.3913973 0.3205515 0.3631170 0.3912085 0.4542176 0.3999505
       [7,] 0.3552658 0.3093184 0.3010842 0.3673017 0.3039875 0.3624589 0.3038551
       [8,] 0.3529021 0.3247552 0.3023912 0.2923464 0.2713716 0.2857859 0.2627253
       [9,] 0.4052576 0.4200867 0.3428421 0.3394161 0.3836950 0.3744232 0.3836853
      [10,] 0.3318198 0.3237023 0.3114730 0.3164056 0.2482132 0.3174561 0.2795323
      [11,] 0.3378625 0.3466853 0.3110601 0.3531750 0.3223733 0.3395988 0.3301624
      [12,] 0.3899277 0.3903709 0.3819310 0.3375635 0.3761191 0.3984483 0.3831656
      [13,] 0.3435705 0.3004923 0.3000919 0.3346717 0.2686236 0.3315578 0.2488448
      [14,] 0.3792346 0.3533612 0.3629485 0.3247464 0.3305258 0.3550107 0.3148869
      [15,] 0.4029821 0.3329319 0.3200534 0.3483374 0.3092085 0.3560920 0.2891205
      [16,] 0.3329319 0.4072145 0.3136260 0.3063168 0.3153526 0.3135427 0.3179032
      [17,] 0.3200534 0.3136260 0.4178473 0.3216383 0.2921914 0.2881410 0.2887689
      [18,] 0.3483374 0.3063168 0.3216383 0.4130369 0.2840406 0.3254596 0.2799843
      [19,] 0.3092085 0.3153526 0.2921914 0.2840406 0.3959299 0.3322660 0.3393178
      [20,] 0.3560920 0.3135427 0.2881410 0.3254596 0.3322660 0.4044005 0.3257537
      [21,] 0.2891205 0.3179032 0.2887689 0.2799843 0.3393178 0.3257537 0.4047794
      [22,] 0.4091661 0.3738722 0.3595939 0.3721547 0.3633162 0.4213864 0.3880263
      [23,] 0.3054019 0.3466469 0.3022233 0.3044542 0.2604175 0.2995181 0.3488779
      [24,] 0.3812947 0.3548821 0.3396105 0.3582028 0.3601843 0.3795341 0.3540605
      [25,] 0.3478419 0.3491553 0.2969050 0.3747642 0.2905926 0.3273992 0.3005663
      [26,] 0.3904225 0.3992663 0.4359671 0.4253176 0.3837960 0.3945064 0.3896817
      [27,] 0.3585833 0.3014212 0.3401771 0.3509750 0.2805411 0.3273872 0.2782515
      [28,] 0.3428719 0.3314276 0.3467582 0.3160977 0.3306523 0.3545179 0.3646012
      [29,] 0.3394214 0.4170320 0.3993973 0.3675633 0.3038418 0.3064804 0.3261697
      [30,] 0.4099238 0.4139901 0.4213449 0.3990849 0.3207753 0.3835597 0.3628194
      [31,] 0.3567115 0.3172887 0.3049912 0.3059889 0.3020181 0.3197710 0.3215577
      [32,] 0.3483399 0.2912989 0.3062592 0.3634603 0.2945235 0.3313570 0.2940884
      [33,] 0.3816499 0.3762535 0.3381053 0.3651828 0.3660556 0.3826280 0.3621237
      [34,] 0.3678903 0.3200297 0.3223298 0.3341906 0.3314275 0.3497056 0.2945803
      [35,] 0.3583229 0.3023115 0.3210037 0.3041208 0.3219870 0.3326105 0.3030481
      [36,] 0.2544942 0.3001889 0.3109006 0.2631206 0.2796083 0.2363907 0.2927193
      [37,] 0.3423002 0.3730642 0.3483797 0.3060860 0.3134191 0.3240729 0.3292184
      [38,] 0.3477659 0.3961409 0.3230067 0.3213942 0.3424865 0.3367813 0.3246403
      [39,] 0.3423561 0.3343108 0.3173556 0.3336023 0.2765495 0.3222561 0.3275091
      [40,] 0.3966873 0.4149241 0.3552640 0.3474666 0.4134704 0.3821023 0.3961611
                [,22]     [,23]     [,24]     [,25]     [,26]     [,27]     [,28]
       [1,] 0.4046782 0.2921442 0.3670381 0.3293533 0.4514919 0.3072870 0.3351851
       [2,] 0.4063992 0.3529623 0.3722187 0.3842095 0.4317108 0.3522197 0.3453512
       [3,] 0.3687206 0.2947198 0.3556825 0.3365811 0.3776675 0.3407901 0.3313021
       [4,] 0.4748479 0.3825395 0.4504677 0.3505797 0.5362912 0.4046125 0.4664949
       [5,] 0.3561605 0.2826722 0.3279440 0.3083936 0.3806510 0.3505049 0.3088645
       [6,] 0.5333569 0.3598854 0.4540149 0.3654656 0.4668916 0.3589900 0.4280774
       [7,] 0.3857608 0.2964741 0.3728457 0.3492568 0.3974679 0.3183809 0.3465275
       [8,] 0.3406292 0.3157345 0.3275562 0.3231252 0.3373112 0.3388433 0.2935088
       [9,] 0.4621339 0.3856858 0.4251279 0.3904057 0.4363885 0.3562988 0.3908359
      [10,] 0.3923090 0.3494546 0.3382506 0.3485463 0.4001063 0.3225072 0.3247119
      [11,] 0.3955028 0.3538506 0.3577489 0.3771474 0.4178917 0.3660954 0.3233924
      [12,] 0.4495619 0.3917857 0.4262159 0.3788117 0.4635879 0.3718644 0.4104011
      [13,] 0.3141189 0.2697028 0.3256938 0.3159366 0.3431673 0.3297816 0.3010204
      [14,] 0.4283485 0.3082309 0.3830319 0.3161134 0.4212106 0.3608778 0.3750590
      [15,] 0.4091661 0.3054019 0.3812947 0.3478419 0.3904225 0.3585833 0.3428719
      [16,] 0.3738722 0.3466469 0.3548821 0.3491553 0.3992663 0.3014212 0.3314276
      [17,] 0.3595939 0.3022233 0.3396105 0.2969050 0.4359671 0.3401771 0.3467582
      [18,] 0.3721547 0.3044542 0.3582028 0.3747642 0.4253176 0.3509750 0.3160977
      [19,] 0.3633162 0.2604175 0.3601843 0.2905926 0.3837960 0.2805411 0.3306523
      [20,] 0.4213864 0.2995181 0.3795341 0.3273992 0.3945064 0.3273872 0.3545179
      [21,] 0.3880263 0.3488779 0.3540605 0.3005663 0.3896817 0.2782515 0.3646012
      [22,] 0.5630475 0.3753065 0.4449969 0.3733252 0.5032117 0.3874373 0.4322735
      [23,] 0.3753065 0.4471016 0.3311823 0.3651890 0.3853135 0.3199225 0.3380487
      [24,] 0.4449969 0.3311823 0.4151443 0.3564034 0.4466317 0.3462490 0.3836512
      [25,] 0.3733252 0.3651890 0.3564034 0.4298102 0.4069444 0.3413267 0.3100067
      [26,] 0.5032117 0.3853135 0.4466317 0.4069444 0.5818781 0.4032938 0.4299712
      [27,] 0.3874373 0.3199225 0.3462490 0.3413267 0.4032938 0.3995114 0.3234780
      [28,] 0.4322735 0.3380487 0.3836512 0.3100067 0.4299712 0.3234780 0.4043163
      [29,] 0.4160148 0.3796291 0.3704163 0.3798308 0.5021081 0.3503216 0.3583275
      [30,] 0.4824457 0.4395676 0.4209159 0.4195498 0.5101399 0.4143516 0.4201927
      [31,] 0.3968881 0.3119012 0.3654678 0.3098126 0.3696027 0.3010211 0.3550438
      [32,] 0.4147757 0.3143400 0.3609095 0.3576175 0.4206899 0.3590449 0.3179471
      [33,] 0.4358190 0.3327537 0.4046812 0.3552375 0.4318491 0.3590810 0.3871017
      [34,] 0.3851446 0.2917805 0.3678323 0.3276997 0.3922857 0.3619419 0.3271772
      [35,] 0.3826448 0.3047897 0.3715418 0.3309257 0.3824156 0.3248125 0.3375729
      [36,] 0.3627135 0.2818273 0.3044356 0.2729893 0.4067361 0.2578816 0.2968476
      [37,] 0.4269345 0.3464054 0.3738811 0.3354771 0.4384104 0.3105591 0.3670421
      [38,] 0.3923521 0.3149255 0.3712310 0.3314089 0.4082615 0.3153282 0.3489113
      [39,] 0.3864728 0.3746239 0.3510428 0.3499524 0.3858336 0.3302087 0.3543242
      [40,] 0.5149685 0.3622524 0.4349479 0.3730711 0.4803461 0.3754398 0.3987842
                [,29]     [,30]     [,31]     [,32]     [,33]     [,34]     [,35]
       [1,] 0.4277095 0.3918940 0.3209992 0.3304344 0.3633943 0.3187196 0.3067201
       [2,] 0.3869842 0.4233512 0.3356011 0.3615479 0.3933628 0.3354348 0.3295164
       [3,] 0.3158980 0.3803228 0.3067535 0.3098770 0.4126571 0.3444837 0.3086434
       [4,] 0.4345843 0.5079662 0.3937972 0.3813640 0.4078071 0.4187835 0.4358080
       [5,] 0.2831570 0.3517907 0.2606738 0.3323581 0.3401322 0.3351518 0.2989232
       [6,] 0.3771593 0.4494309 0.3971114 0.3808892 0.4569400 0.3974189 0.3744900
       [7,] 0.3238047 0.3917467 0.3341408 0.3229543 0.3942821 0.3215929 0.3193445
       [8,] 0.3255437 0.3773517 0.3151219 0.3101098 0.3271257 0.3434242 0.3355117
       [9,] 0.4056847 0.4505271 0.4048709 0.3605160 0.4471554 0.3851384 0.3918822
      [10,] 0.3709777 0.4349212 0.3019086 0.3237806 0.3090527 0.2983263 0.3211793
      [11,] 0.3798311 0.4046103 0.2964317 0.3617166 0.3839613 0.3592944 0.3102746
      [12,] 0.3901575 0.4724630 0.3670353 0.3625330 0.3851377 0.3967367 0.4325159
      [13,] 0.3028651 0.3729573 0.2776221 0.2743012 0.3774804 0.3314950 0.2788364
      [14,] 0.3793250 0.4305713 0.3516817 0.3224096 0.4184469 0.3647405 0.3399177
      [15,] 0.3394214 0.4099238 0.3567115 0.3483399 0.3816499 0.3678903 0.3583229
      [16,] 0.4170320 0.4139901 0.3172887 0.2912989 0.3762535 0.3200297 0.3023115
      [17,] 0.3993973 0.4213449 0.3049912 0.3062592 0.3381053 0.3223298 0.3210037
      [18,] 0.3675633 0.3990849 0.3059889 0.3634603 0.3651828 0.3341906 0.3041208
      [19,] 0.3038418 0.3207753 0.3020181 0.2945235 0.3660556 0.3314275 0.3219870
      [20,] 0.3064804 0.3835597 0.3197710 0.3313570 0.3826280 0.3497056 0.3326105
      [21,] 0.3261697 0.3628194 0.3215577 0.2940884 0.3621237 0.2945803 0.3030481
      [22,] 0.4160148 0.4824457 0.3968881 0.4147757 0.4358190 0.3851446 0.3826448
      [23,] 0.3796291 0.4395676 0.3119012 0.3143400 0.3327537 0.2917805 0.3047897
      [24,] 0.3704163 0.4209159 0.3654678 0.3609095 0.4046812 0.3678323 0.3715418
      [25,] 0.3798308 0.4195498 0.3098126 0.3576175 0.3552375 0.3276997 0.3309257
      [26,] 0.5021081 0.5101399 0.3696027 0.4206899 0.4318491 0.3922857 0.3824156
      [27,] 0.3503216 0.4143516 0.3010211 0.3590449 0.3590810 0.3619419 0.3248125
      [28,] 0.3583275 0.4201927 0.3550438 0.3179471 0.3871017 0.3271772 0.3375729
      [29,] 0.5562114 0.4896433 0.3201169 0.3412564 0.3858215 0.3268655 0.2998863
      [30,] 0.4896433 0.5604001 0.3818702 0.3887106 0.4317382 0.3790934 0.3781906
      [31,] 0.3201169 0.3818702 0.3813176 0.3107423 0.3666519 0.3145105 0.3413322
      [32,] 0.3412564 0.3887106 0.3107423 0.4028639 0.3279293 0.3447714 0.3375131
      [33,] 0.3858215 0.4317382 0.3666519 0.3279293 0.5115058 0.3683147 0.3183061
      [34,] 0.3268655 0.3790934 0.3145105 0.3447714 0.3683147 0.3886675 0.3474166
      [35,] 0.2998863 0.3781906 0.3413322 0.3375131 0.3183061 0.3474166 0.4157505
      [36,] 0.3992034 0.3401047 0.2711894 0.2902113 0.2902643 0.2515062 0.2591211
      [37,] 0.4197093 0.4377885 0.3444593 0.3202151 0.3562870 0.3131996 0.3377408
      [38,] 0.4048258 0.4059210 0.3258159 0.2927319 0.4211501 0.3429983 0.2983918
      [39,] 0.3608347 0.4316374 0.3462349 0.3132448 0.3930252 0.3068435 0.3068626
      [40,] 0.4386672 0.4426953 0.3904327 0.3934714 0.4677351 0.4012890 0.3686771
                [,36]     [,37]     [,38]     [,39]     [,40]
       [1,] 0.3709173 0.3747756 0.3645088 0.3080024 0.4362794
       [2,] 0.3094088 0.3482068 0.3434428 0.3640326 0.4125146
       [3,] 0.2352705 0.3025652 0.3443278 0.3355290 0.3767652
       [4,] 0.3380354 0.4241205 0.3946202 0.3848462 0.4305746
       [5,] 0.2257843 0.2659261 0.2756704 0.2924023 0.3363838
       [6,] 0.3056635 0.4055969 0.4240096 0.3766813 0.4993309
       [7,] 0.2402585 0.3187351 0.3299400 0.3508378 0.3431162
       [8,] 0.2370985 0.3102639 0.3191465 0.3091127 0.3742521
       [9,] 0.3357440 0.4125572 0.4189078 0.3884269 0.5217239
      [10,] 0.2703925 0.3560512 0.3061028 0.3297345 0.3386285
      [11,] 0.2874996 0.3232770 0.3536871 0.3310730 0.4284365
      [12,] 0.2988993 0.4074992 0.3836219 0.3640645 0.4327775
      [13,] 0.1794404 0.2703437 0.3285568 0.3208774 0.2919186
      [14,] 0.2905320 0.3675738 0.3830229 0.3476835 0.4346810
      [15,] 0.2544942 0.3423002 0.3477659 0.3423561 0.3966873
      [16,] 0.3001889 0.3730642 0.3961409 0.3343108 0.4149241
      [17,] 0.3109006 0.3483797 0.3230067 0.3173556 0.3552640
      [18,] 0.2631206 0.3060860 0.3213942 0.3336023 0.3474666
      [19,] 0.2796083 0.3134191 0.3424865 0.2765495 0.4134704
      [20,] 0.2363907 0.3240729 0.3367813 0.3222561 0.3821023
      [21,] 0.2927193 0.3292184 0.3246403 0.3275091 0.3961611
      [22,] 0.3627135 0.4269345 0.3923521 0.3864728 0.5149685
      [23,] 0.2818273 0.3464054 0.3149255 0.3746239 0.3622524
      [24,] 0.3044356 0.3738811 0.3712310 0.3510428 0.4349479
      [25,] 0.2729893 0.3354771 0.3314089 0.3499524 0.3730711
      [26,] 0.4067361 0.4384104 0.4082615 0.3858336 0.4803461
      [27,] 0.2578816 0.3105591 0.3153282 0.3302087 0.3754398
      [28,] 0.2968476 0.3670421 0.3489113 0.3543242 0.3987842
      [29,] 0.3992034 0.4197093 0.4048258 0.3608347 0.4386672
      [30,] 0.3401047 0.4377885 0.4059210 0.4316374 0.4426953
      [31,] 0.2711894 0.3444593 0.3258159 0.3462349 0.3904327
      [32,] 0.2902113 0.3202151 0.2927319 0.3132448 0.3934714
      [33,] 0.2902643 0.3562870 0.4211501 0.3930252 0.4677351
      [34,] 0.2515062 0.3131996 0.3429983 0.3068435 0.4012890
      [35,] 0.2591211 0.3377408 0.2983918 0.3068626 0.3686771
      [36,] 0.4220373 0.3496548 0.2905701 0.2660560 0.4066057
      [37,] 0.3496548 0.4139086 0.3615792 0.3398438 0.4231177
      [38,] 0.2905701 0.3615792 0.4243788 0.3349206 0.4348109
      [39,] 0.2660560 0.3398438 0.3349206 0.3967751 0.3664759
      [40,] 0.4066057 0.4231177 0.4348109 0.3664759 0.6118455

# `mi_df()` examples work

    Code
      mi_df(bag_label = factor(c(1, 1, 0)), bag_name = c(rep("bag_1", 2), "bag_2"),
      X1 = c(-0.4, 0.5, 2), instance_label = c(0, 1, 0))
    Output
      # An MI data frame: 3 x 3 with 2 bags
      # and instance labels: 0, 1, 0
        bag_label bag_name    X1
        <fct>     <chr>    <dbl>
      1 1         bag_1     -0.4
      2 1         bag_1      0.5
      3 0         bag_2      2  

# `mi()` examples work

    Code
      mil_data <- generate_mild_df(positive_degree = 3, nbag = 10)
      with(mil_data, head(mi(bag_label, bag_name)))
    Output
           bag_label bag_name
      [1,] "1"       "bag1"  
      [2,] "1"       "bag1"  
      [3,] "1"       "bag1"  
      [4,] "1"       "bag1"  
      [5,] "1"       "bag1"  
      [6,] "1"       "bag1"  
    Code
      df <- get_all_vars(mi(bag_label, bag_name) ~ X1 + X2, data = mil_data)
      head(df)
    Output
        bag_label bag_name         X1         X2
      1         1     bag1 -0.4464099  1.1019817
      2         1     bag1  1.2311306 -0.8395224
      3         1     bag1  0.9309844  2.2884239
      4         1     bag1  2.0311929  2.1704369
      5         1     bag1  0.5209816 -1.1255467
      6         1     bag1 -0.4920105  2.4251912

# `mild_df()` examples work

    Code
      mild_df(bag_label = factor(c(1, 1, 0)), bag_name = c(rep("bag_1", 2), "bag_2"),
      instance_name = c("bag_1_inst_1", "bag_1_inst_2", "bag_2_inst_1"), X1 = c(-0.4,
        0.5, 2), instance_label = c(0, 1, 0))
    Output
      # An MILD data frame: 3 x 4 with 2 bags, 3 instances
      # and instance labels: 0, 1, 0
        bag_label bag_name instance_name    X1
        <fct>     <chr>    <chr>         <dbl>
      1 1         bag_1    bag_1_inst_1   -0.4
      2 1         bag_1    bag_1_inst_2    0.5
      3 0         bag_2    bag_2_inst_1    2  

# `mild()` examples work

    Code
      mil_data <- generate_mild_df(positive_degree = 3, nbag = 10)
      with(mil_data, head(mild(bag_label, bag_name, instance_name)))
    Output
           bag_label bag_name instance_name
      [1,] "1"       "bag1"   "bag1inst1"  
      [2,] "1"       "bag1"   "bag1inst1"  
      [3,] "1"       "bag1"   "bag1inst1"  
      [4,] "1"       "bag1"   "bag1inst1"  
      [5,] "1"       "bag1"   "bag1inst1"  
      [6,] "1"       "bag1"   "bag1inst1"  
    Code
      df <- get_all_vars(mild(bag_label, bag_name) ~ X1 + X2, data = mil_data)
      head(df)
    Output
        bag_label bag_name          X1         X2
      1         1     bag1  0.36529504 -0.3713889
      2         1     bag1  0.07733708 -0.5885037
      3         1     bag1 -1.59611098  0.3456669
      4         1     bag1 -0.16911543  1.4814259
      5         1     bag1 -0.85251086 -2.6362243
      6         1     bag1  1.40033082 -1.1679564

# `predict.mismm()` examples work

    Code
      mil_data <- generate_mild_df(nbag = 15, nsample = 20, positive_prob = 0.15,
        sd_of_mean = rep(0.1, 3))
      mdl1 <- mismm(mil_data, control = list(sigma = 1 / 5))
      mil_data %>% dplyr::bind_cols(predict(mdl1, mil_data, type = "class")) %>%
        dplyr::bind_cols(predict(mdl1, mil_data, type = "raw")) %>% dplyr::distinct(
        bag_name, bag_label, .pred_class, .pred)
    Output
      # A tibble: 15 x 4
         bag_name bag_label .pred_class   .pred
         <chr>        <dbl> <fct>         <dbl>
       1 bag1             0 0           -0.377 
       2 bag2             1 1            0.283 
       3 bag3             0 0           -0.332 
       4 bag4             1 1            0.132 
       5 bag5             0 0           -0.335 
       6 bag6             0 0           -0.248 
       7 bag7             1 1            0.261 
       8 bag8             0 0           -0.0604
       9 bag9             1 1            0.379 
      10 bag10            1 1            0.392 
      11 bag11            1 1            0.301 
      12 bag12            0 0           -0.282 
      13 bag13            1 1            0.326 
      14 bag14            1 1            0.223 
      15 bag15            1 1            0.459 
    Code
      mil_data %>% dplyr::bind_cols(predict(mdl1, mil_data, type = "class", layer = "instance")) %>%
        dplyr::bind_cols(predict(mdl1, mil_data, type = "raw", layer = "instance")) %>%
        dplyr::distinct(bag_label, bag_name, instance_name, .pred_class, .pred)
    Output
      # An MILD data frame: 60 x 5 with 15 bags, 60 instances
      # and instance labels: 0, 0, 0, 0, 0, ...
         bag_label bag_name instance_name .pred_class  .pred
             <dbl> <chr>    <chr>         <fct>        <dbl>
       1         0 bag1     bag1inst1     0           -0.380
       2         0 bag1     bag1inst2     0           -0.421
       3         0 bag1     bag1inst3     0           -0.377
       4         0 bag1     bag1inst4     0           -0.428
       5         1 bag2     bag2inst1     0           -0.321
       6         1 bag2     bag2inst2     0           -0.363
       7         1 bag2     bag2inst3     0           -0.251
       8         1 bag2     bag2inst4     1            0.283
       9         0 bag3     bag3inst1     0           -0.332
      10         0 bag3     bag3inst2     0           -0.395
      # i 50 more rows

# `misvm_orova()` examples work

    Code
      data("ordmvnorm")
      x <- ordmvnorm[, 3:7]
    Warning <rlang_warning>
      Dropping 'mi_df' class as required column was removed.
    Code
      y <- ordmvnorm$bag_label
      bags <- ordmvnorm$bag_name
      mdl1 <- misvm_orova(x, y, bags)
      predict(mdl1, x, new_bags = bags)
    Output
      # A tibble: 1,000 x 1
         .pred_class
         <fct>      
       1 2          
       2 2          
       3 2          
       4 2          
       5 2          
       6 3          
       7 3          
       8 3          
       9 3          
      10 3          
      # i 990 more rows
    Code
      df1 <- dplyr::bind_cols(y = y, bags = bags, as.data.frame(x))
      df1 %>% dplyr::bind_cols(predict(mdl1, df1, new_bags = bags, type = "class")) %>%
        dplyr::bind_cols(predict(mdl1, df1, new_bags = bags, type = "raw")) %>%
        dplyr::select(-starts_with("V")) %>% dplyr::distinct()
    Output
          y bags .pred_class      .pred_1     .pred_2      .pred_3      .pred_4
      1   2    1           2  0.072054072  1.24157688 -0.005075918 -0.783087461
      2   4    2           3 -1.251419361 -0.44724656  2.357316056  1.435526426
      3   1    3           1  2.266372449  2.26051385 -1.635840749 -2.449979864
      4   3    4           2  2.036194818  2.48865381  1.218059767 -0.176115919
      5   1    5           1  0.999497111  0.43651819 -0.486774613 -2.238297731
      6   5    6           3  1.920010812  1.38391110  4.473871500  3.981368930
      7   4    7           3  0.730430029  1.07444170  1.818187547  1.000264053
      8   4    8           3  0.036505464  1.31947988  3.995412773  3.083747508
      9   3    9           3  0.209234901 -1.10561202  1.961314768  0.552380675
      10  4   10           3 -0.504233266  0.76282372  3.153695469  2.711460653
      11  5   11           3  0.054740339 -0.68454697  3.078920102  2.023132149
      12  3   12           3 -0.164563516 -1.97443357  0.926269029  0.107442544
      13  5   13           3 -0.569257195 -1.50596301  4.681906898  4.271581859
      14  3   14           1  1.797814850  0.68511482  1.334480188 -0.018156454
      15  2   15           2  0.354159148  1.30396993  0.299802741 -0.792499384
      16  3   16           2  0.900791960  1.64894819  0.733013977 -0.243052192
      17  2   17           1  2.751060969  2.09543404  0.767178044 -0.206214135
      18  2   18           2  0.012863158  2.62296119 -0.093230935 -1.409281102
      19  2   19           1  1.205695843  1.01526852 -1.054750654 -2.326673454
      20  1   20           2  0.001415356  1.07104086 -0.896129480 -2.233466605
      21  3   21           3 -0.219947873  0.79395459  2.593885919  1.339418082
      22  2   22           1  0.954808999 -0.13140503  0.154058385 -1.048479675
      23  3   23           2 -0.951905691  1.20592625  0.833612057 -0.742110448
      24  4   24           3 -0.273808301  0.37504428  2.761489395  1.500488098
      25  2   25           2 -0.151453073  1.78821302  0.097761509 -0.625524717
      26  4   26           3  0.548553011  0.91816008  2.692972337  1.529978372
      27  4   27           3 -0.838129504  0.87575492  2.942167421  2.106161023
      28  2   28           2 -0.459396273  2.71463070  0.030473723 -0.949329104
      29  5   29           3  0.168078546 -0.42048836  3.765049712  3.077313282
      30  3   30           3  0.204011620  0.89524867  1.470316006  1.152517057
      31  2   31           3 -0.353540848  0.06905779  0.518345886 -1.117263057
      32  5   32           3  0.347529726  1.96050469  4.092332114  2.777554297
      33  2   33           1  1.551470304 -0.17652552  0.458605980 -0.467230099
      34  5   34           3  0.812941100  1.27701647  3.693666669  3.265801954
      35  4   35           1  2.870066694  1.07442101  1.734199670  0.962302122
      36  3   36           3 -0.551027795  0.06258126  1.308833458  0.575725816
      37  4   37           3  0.989409528 -0.63987667  3.171262186  2.424230459
      38  2   38           1  2.284649128  0.31490852 -0.048948873 -1.266380708
      39  4   39           3  1.067812621 -0.09306674  2.750077773  1.984667458
      40  2   40           3  0.520817262 -1.62116210  0.957123790 -0.829010258
      41  1   41           1  1.274290440  0.83835316 -1.056238423 -2.538301933
      42  1   42           2  1.984378137  2.66491196 -0.485998231 -2.147887984
      43  2   43           2 -0.145363418  0.80692325 -0.709848943 -1.783606824
      44  2   44           2  0.401963950  1.08925411  0.430524106 -1.210678768
      45  2   45           1  2.090161856  1.42710530  0.305093008 -0.860630133
      46  3   46           3 -0.179769147  0.67295977  0.923519375  0.166548835
      47  3   47           1  3.023586198 -0.04441672  0.870074332  0.082737064
      48  4   48           3  0.594910297 -0.40790117  3.108895289  2.441552201
      49  2   49           2  0.517934018  0.99982514  0.971428071 -0.477676824
      50  4   50           3  0.841524707  0.12691384  2.288197352  1.508173550
      51  3   51           1  2.179260305 -0.85912454  0.816258705 -0.086590741
      52  5   52           3  1.123590058  1.32385089  4.606127446  3.815318462
      53  5   53           3  1.523522406 -0.05627962  2.949281404  2.487092570
      54  2   54           2  0.256062043  0.41876378  0.199033146 -0.590743872
      55  4   55           2 -0.307830686  1.91476237  1.854087045  1.132002454
      56  3   56           3 -1.072896286 -0.08795983  1.536126899  0.926894203
      57  5   57           3  2.095149008 -0.07867520  4.525285138  3.668547097
      58  1   58           1  1.509681540  0.36224184 -1.179052225 -2.919152012
      59  2   59           1  1.500651712  1.23943073 -0.487119290 -1.529960657
      60  4   60           3  0.153476330  1.12512087  2.965594188  1.719696833
      61  2   61           2  0.107433901  0.99998094  0.251861562 -0.668879441
      62  2   62           2  1.021472500  1.10098424 -0.483214988 -1.764205357
      63  2   63           2 -0.577488392  0.96101424 -0.147362894 -1.373661079
      64  5   64           3 -1.470440642  0.34004044  3.749092557  3.320600526
      65  2   65           2 -0.115208922  1.35927809 -0.037468827 -2.140192951
      66  4   66           3  0.492635619  1.70587041  3.828368807  3.067970029
      67  2   67           2  1.314915397  1.52793709 -0.531016585 -2.183768654
      68  4   68           3  0.997063986  1.44167808  2.692431224  1.871823863
      69  1   69           2  0.179755225  1.01227117 -1.192076661 -1.692757366
      70  2   70           2  0.950844268  1.21782268  0.712069112 -0.805553592
      71  4   71           3  0.570080774  0.96193964  2.624338049  2.296915214
      72  4   72           3 -1.453889746  0.58589034  2.658095509  1.339789694
      73  1   73           2  1.445004530  1.45944954 -1.468585910 -2.382518721
      74  5   74           3  0.331242540  1.17657845  5.302493853  4.687040860
      75  5   75           3  2.064429323  2.96099424  4.444482071  3.548902076
      76  4   76           3 -0.028601890  0.19153408  2.991329788  2.446507117
      77  1   77           2 -0.189502244  0.29768322 -1.143863726 -2.113323367
      78  3   78           3  0.813181217 -1.00040792  2.280448356  2.116439098
      79  2   79           2 -0.712710553  0.55617328  0.517086303 -0.093885228
      80  1   80           1  1.630919431  0.73688837 -0.341944665 -1.446730604
      81  3   81           3  0.902920480 -0.86940201  2.091036922  0.798079169
      82  3   82           1  1.636798724  0.36720409  0.526272127 -0.661387375
      83  2   83           1  1.531500293  1.51018878 -0.503977890 -1.535820327
      84  5   84           3  0.464437512  1.83063333  4.740010492  3.734087786
      85  2   85           1  2.447572647  1.09642106  0.481866056 -0.500450818
      86  2   86           1  2.693553783  0.99995510 -0.292739964 -1.303295992
      87  3   87           3  0.882733260  0.02994256  2.026985038  0.973188925
      88  3   88           3  0.769492513  0.60412049  1.149114506  0.006639411
      89  3   89           3  1.163435069  1.04646194  1.424447656  0.273940686
      90  2   90           2  0.594042888  1.61961486 -0.251107974 -1.180828674
      91  3   91           3 -0.383868294  0.22873649  1.000184845 -0.190455535
      92  4   92           3  1.445654335  0.92329461  2.390422626  1.353768980
      93  3   93           3  0.895493731  1.56358634  2.242955217  1.189125683
      94  2   94           3  0.907150996  0.92386627  1.188409683 -0.471069578
      95  3   95           2  0.762152263  1.03743805  0.791851575 -0.165396439
      96  3   96           1  0.715915316 -0.39463666  0.255683255 -0.150974367
      97  2   97           3 -0.155145008 -0.57753861  0.473907217 -0.555776688
      98  2   98           2  0.135714595  0.41352574 -0.208214572 -0.552287748
      99  2   99           2 -0.141625157  2.23280495 -0.074145655 -0.817376099
      100 2  100           2 -0.019076930  1.04704126  0.434395332 -0.999866642
      101 2  101           1  1.277564724  0.63581165  0.362761950 -1.742433608
      102 2  102           3 -0.006713045 -0.03519697  0.371099531 -1.000979568
      103 2  103           1  1.150995278  0.93893790 -0.453058573 -1.565305108
      104 5  104           3 -0.084590673  0.32435353  4.722037336  4.096075587
      105 1  105           1  1.049951247  0.51900629 -0.407220119 -1.882503879
      106 3  106           3 -0.380301725  0.22443279  1.623335874  0.343203060
      107 3  107           2  0.375821293  2.64082208  0.999198140 -0.301840905
      108 1  108           1  1.111465715  0.66199956 -1.247840729 -2.510232570
      109 3  109           3  0.666430137  0.99386114  2.098551048  1.569297967
      110 5  110           3  0.908593319  1.15870068  3.672511343  3.623525435
      111 1  111           2  0.200115809  0.27917410 -0.454184020 -2.031033198
      112 3  112           1  0.917679336  0.28386471  0.656506910 -0.746684752
      113 2  113           1  1.798310728  1.31431887 -0.836225608 -2.183067661
      114 1  114           2  0.999975552  1.06284430 -1.139154293 -2.323531747
      115 5  115           3 -1.292889704  2.43593054  3.738333559  2.593191003
      116 2  116           2  0.195980600  1.12561416 -0.147867431 -0.403210177
      117 4  117           3  0.653941590  1.06963348  1.839933954  1.000262988
      118 2  118           2  0.573141965  0.73200876  0.536599552 -0.584070336
      119 1  119           1  1.209429578  0.35359752 -0.202944858 -1.454486222
      120 5  120           3  1.272566079  1.55025619  4.051944143  3.215528155
      121 1  121           1  0.308112225  0.18483777 -0.868885078 -1.793322748
      122 2  122           2 -1.538849904  0.84322486 -0.120521607 -1.199301261
      123 3  123           2 -0.448733944  2.76807920  1.993302722  0.786583597
      124 3  124           3  1.581181008  1.76559761  1.819032454  0.840982124
      125 2  125           1  0.119633865  0.10412126 -0.099776725 -1.407163380
      126 2  126           2  0.393379327  0.86242251  0.069857642 -1.779543657
      127 5  127           3  0.590272911  1.32850469  4.183207523  3.832928424
      128 3  128           3  0.472820279  0.82437661  1.717874666  1.333198988
      129 1  129           2  0.943847045  2.73668518 -1.419371165 -3.087451597
      130 3  130           2  0.810135639  1.85824791  0.961275675 -0.917301006
      131 4  131           3  0.358246998 -0.44392872  2.906291423  2.561670550
      132 2  132           2  0.774586840  1.66293656  0.855561712 -0.917567867
      133 3  133           3 -0.550711238 -0.56926697  0.694228446 -0.678812703
      134 5  134           3 -0.012112268  1.22860183  4.465948576  3.602452262
      135 4  135           4 -0.291949799  1.11774318  2.222342191  2.343471199
      136 5  136           3  0.942324879  2.65928102  3.974654849  2.632401842
      137 2  137           1  1.778003397  1.11342719  0.160190292 -1.000126956
      138 5  138           3  0.855095736  0.55893253  4.161465376  3.197801129
      139 5  139           3  0.636543509  1.53739284  3.875415445  3.548614790
      140 3  140           3  0.100977767  1.02563567  1.517060405  0.519591116
      141 2  141           1  1.363349313  1.09390713 -0.265016510 -1.889752422
      142 3  142           3  0.517022989  0.47420072  1.822826898  0.149811006
      143 3  143           3  0.420427055  0.62233735  0.844955376 -0.436951189
      144 5  144           3 -1.144003804  0.96698257  3.728894705  3.555935707
      145 4  145           3  1.202471103  0.65641832  2.188028475  1.084486715
      146 1  146           2  1.396454476  1.48357989 -1.094755032 -2.171843353
      147 5  147           3  0.777818253  1.31950973  3.630842333  3.439383932
      148 3  148           3 -2.086082825 -0.18524611  1.090262754 -0.149644034
      149 3  149           3  1.012761279  1.79634256  2.103497227  0.745128077
      150 1  150           2  0.885941333  1.48454696 -0.061515541 -0.783359064
      151 4  151           3  0.013111638 -0.22119890  1.932968374  1.012871724
      152 2  152           2 -0.530687880 -0.06287797 -0.651997451 -1.669859980
      153 4  153           3  0.869793218  0.77671031  1.728178617  0.914770455
      154 2  154           2  0.190652685  1.71395014 -0.229030835 -1.543881873
      155 1  155           2 -0.178580776  0.92305141 -1.036292130 -2.165478548
      156 1  156           2  1.000201483  2.92361363 -1.325700627 -2.729749197
      157 2  157           2 -0.015094567  1.91893656  0.031534694 -0.946125280
      158 4  158           3 -0.812626914  0.95648766  2.806138958  1.876790794
      159 2  159           3 -1.147613773  0.70381535  1.078614431  0.001691334
      160 3  160           3 -0.005963495 -0.42144411  1.346029283  0.866144024
      161 4  161           3 -0.487768292  0.16039940  1.889244350  0.838848852
      162 4  162           3 -0.325277453  0.44750972  3.522302671  2.334300848
      163 2  163           1  0.810485670  0.21194222 -0.236538595 -0.989193244
      164 4  164           3 -0.586188903 -1.40828162  3.153760500  2.445556093
      165 2  165           1  1.707600456  1.64506602 -0.354574953 -1.106089709
      166 1  166           1  0.516966404  0.43037407 -0.843319109 -2.105307436
      167 1  167           1  1.240764247  0.96035169 -1.403132441 -2.723452555
      168 2  168           2  1.150271113  3.59719968  0.710025608 -0.772309968
      169 3  169           3  1.154990522  1.21336040  1.537909335  0.282153028
      170 3  170           2 -0.530602126  1.44399045  0.164801983 -1.276018499
      171 4  171           3 -0.157253345 -1.14002239  2.117835761  1.000416289
      172 1  172           1  1.374174118  0.40075009 -0.778209698 -2.335232604
      173 2  173           1  2.333911387  0.39848361  0.235552515 -0.829819104
      174 3  174           3 -0.332185510 -1.33640388  1.172623486  0.066823119
      175 2  175           3 -0.327081449  0.10316262  1.302235951  0.484237839
      176 2  176           2  1.015949323  1.80174907  0.017039788 -0.945153995
      177 4  177           3  0.403523641 -0.63949231  1.274572759  0.172783384
      178 2  178           1  1.088188898  0.51355476 -0.078971488 -0.744362702
      179 2  179           2 -0.164286920  1.15585033 -0.356885685 -1.492212171
      180 3  180           1  1.518219908 -0.07355124  1.000179024 -0.598403065
      181 3  181           1  2.102301483  1.52374512  0.422707945 -0.485696539
      182 2  182           1  0.579630818  0.47244020 -0.683296348 -1.185304536
      183 3  183           2  1.902651105  2.28923504  2.161821025  1.637501923
      184 1  184           1  1.540113414  1.46968383 -0.429542642 -1.565683732
      185 2  185           1  1.909916536 -0.52104883  0.749757617 -0.642477039
      186 4  186           3  0.141069414  1.23662770  2.006894338  0.999448779
      187 2  187           2  0.542736128  1.86111012  0.294251330 -0.339388904
      188 3  188           1  1.384725699 -1.51205961 -0.039519134 -1.270476702
      189 3  189           1  1.864789106  1.47779347  1.182041810  0.389903457
      190 5  190           3 -0.574479151  0.11035482  4.014472592  3.270696550
      191 4  191           3  0.068318643  1.33079012  2.639410743  1.645692123
      192 2  192           2  0.326891249  1.53619415  0.133795222 -1.210934106
      193 2  193           1  2.007857820  0.70729058 -0.565017074 -1.370434743
      194 2  194           2  1.067989221  3.13948837  0.476273288 -0.756853035
      195 5  195           3  1.210197177 -0.75076373  4.808854585  4.473698884
      196 3  196           3  0.362578606  1.26753424  1.347520007 -0.131381656
      197 2  197           3 -0.640280205  0.29798615  1.585048445  0.502836911
      198 3  198           3  0.461652471 -2.05551325  1.000172781  0.125844624
      199 1  199           1  1.000201245 -0.28377772 -0.529427122 -1.847119454
      200 1  200           1  1.815506761  0.29396669 -0.726221317 -1.510439568
              .pred_5
      1   -2.58002883
      2   -0.07684673
      3   -4.35822799
      4   -1.95356763
      5   -3.99207671
      6    1.93351275
      7   -0.66240349
      8    1.18028676
      9   -1.16592851
      10   0.77978484
      11   1.00035160
      12  -1.50176706
      13   2.41059782
      14  -1.53078230
      15  -2.92647034
      16  -1.84243289
      17  -1.57981776
      18  -3.17228600
      19  -3.74323245
      20  -4.02264278
      21  -0.19119280
      22  -2.75209990
      23  -2.69603183
      24  -0.24203523
      25  -2.69850191
      26  -0.19472477
      27   0.53465529
      28  -2.63182959
      29   1.00007002
      30  -0.92024133
      31  -2.47197917
      32   1.49964739
      33  -2.12023746
      34   1.68804362
      35  -0.58162609
      36  -0.81888860
      37   0.78236444
      38  -3.10579054
      39   0.47156372
      40  -2.18379805
      41  -4.40018543
      42  -3.90076015
      43  -3.27682785
      44  -2.74666887
      45  -2.68843170
      46  -1.81494788
      47  -1.47035622
      48   0.46722703
      49  -1.99203120
      50  -0.12349569
      51  -2.10959676
      52   2.09263402
      53   0.99979963
      54  -2.73581967
      55  -1.01611189
      56  -0.83358768
      57   1.92926482
      58  -4.54639348
      59  -3.41947711
      60   0.19544692
      61  -2.46984187
      62  -3.65850087
      63  -3.19360474
      64   1.82827101
      65  -3.47411810
      66   1.21509269
      67  -4.21862304
      68   0.38832820
      69  -3.81505895
      70  -2.07675393
      71   0.53085258
      72   0.42778565
      73  -4.48460656
      74   2.92744210
      75   2.14952714
      76   0.54757355
      77  -4.11282145
      78  -0.05549175
      79  -2.04012566
      80  -3.52356153
      81  -0.74699403
      82  -2.63327923
      83  -3.76415925
      84   2.40164351
      85  -2.37326774
      86  -3.29600258
      87  -0.64494508
      88  -1.55588564
      89  -1.23462421
      90  -3.14457588
      91  -1.55665731
      92  -0.46741107
      93  -0.36071430
      94  -2.13941056
      95  -1.88584105
      96  -2.31279814
      97  -2.72506481
      98  -2.55486628
      99  -2.62755342
      100 -2.93103959
      101 -3.13908949
      102 -2.36598414
      103 -3.13311286
      104  2.47607255
      105 -3.87597827
      106 -1.13580430
      107 -1.80780393
      108 -4.02513628
      109 -0.53160920
      110  1.69841162
      111 -3.88190764
      112 -2.56385998
      113 -3.86837437
      114 -4.14417630
      115  0.99942799
      116 -2.65863372
      117 -0.76754823
      118 -2.27942602
      119 -3.27317032
      120  1.72560788
      121 -4.02924537
      122 -2.98682699
      123 -0.63185022
      124 -1.05365132
      125 -3.25180121
      126 -3.09785064
      127  1.89772202
      128 -1.03007030
      129 -4.76932157
      130 -1.83026680
      131  0.70763604
      132 -2.51050644
      133 -2.30067396
      134  1.96546545
      135  0.10061140
      136  1.41747201
      137 -3.10551589
      138  1.72763109
      139  1.97737571
      140 -1.46789447
      141 -3.59107922
      142 -1.20986782
      143 -1.97876091
      144  1.71976446
      145  0.03445753
      146 -3.79717233
      147  1.31584588
      148 -1.83044632
      149 -0.99217495
      150 -3.09378730
      151 -0.50430058
      152 -3.69861394
      153 -1.01143389
      154 -3.10652562
      155 -3.98430332
      156 -4.34843602
      157 -2.82600550
      158  0.29058746
      159 -1.71037418
      160 -1.14003962
      161 -0.86219140
      162  0.86711891
      163 -2.71227855
      164  1.13242136
      165 -3.25077099
      166 -4.21184001
      167 -4.32908290
      168 -2.53025092
      169 -1.20668692
      170 -2.53536903
      171 -0.89845528
      172 -4.16588482
      173 -2.50545962
      174 -1.58712329
      175 -1.15430985
      176 -2.73924017
      177 -1.37722823
      178 -2.54843043
      179 -3.27672842
      180 -2.12158393
      181 -2.24123529
      182 -3.47317552
      183 -0.10937610
      184 -3.30503450
      185 -2.34538027
      186 -0.92687356
      187 -2.09575427
      188 -2.95018409
      189 -1.63822035
      190  1.89281930
      191 -0.10896206
      192 -2.93719691
      193 -3.31089481
      194 -2.75203056
      195  2.99187180
      196 -1.53222689
      197 -1.06215402
      198 -1.69979180
      199 -3.50721222
      200 -3.37582254

# `smm()` examples work

    Code
      set.seed(8)
      n_instances <- 10
      n_samples <- 20
      y <- rep(c(1, -1), each = n_samples * n_instances / 2)
      instances <- as.character(rep(1:n_instances, each = n_samples))
      x <- data.frame(x1 = rnorm(length(y), mean = 1 * (y == 1)), x2 = rnorm(length(y),
      mean = 2 * (y == 1)), x3 = rnorm(length(y), mean = 3 * (y == 1)))
      df <- data.frame(instance_name = instances, y = y, x)
      mdl <- smm(x, y, instances)
      mdl2 <- smm(y ~ ., data = df)
      df %>% dplyr::bind_cols(predict(mdl, type = "raw", new_data = x, new_instances = instances)) %>%
        dplyr::bind_cols(predict(mdl, type = "class", new_data = x, new_instances = instances)) %>%
        dplyr::distinct(instance_name, y, .pred, .pred_class)
    Output
         instance_name  y      .pred .pred_class
      1              1  1  1.0000000           1
      2              2  1  0.9216801           1
      3              3  1  1.0847376           1
      4              4  1  0.9357988           1
      5              5  1  0.9247263           1
      6              6 -1 -0.9880539          -1
      7              7 -1 -0.7498163          -1
      8              8 -1 -0.9375437          -1
      9              9 -1 -1.0000000          -1
      10            10 -1 -1.0317597          -1

# `summarize_samples()` examples work

    Code
      fns <- list(mean = mean, sd = sd)
      suppressMessages({
        summarize_samples(mtcars, group_cols = c("cyl", "gear"), .fns = fns) %>%
          print()
        summarize_samples(mtcars, group_cols = c("cyl", "gear"), .fns = fns, cor = TRUE) %>%
          print()
      })
    Output
      # A tibble: 8 x 20
          cyl  gear mpg_mean disp_mean hp_mean drat_mean wt_mean qsec_mean vs_mean
        <dbl> <dbl>    <dbl>     <dbl>   <dbl>     <dbl>   <dbl>     <dbl>   <dbl>
      1     4     3     21.5      120.     97       3.7     2.46      20.0     1  
      2     4     4     26.9      103.     76       4.11    2.38      19.6     1  
      3     4     5     28.2      108.    102       4.1     1.83      16.8     0.5
      4     6     3     19.8      242.    108.      2.92    3.34      19.8     1  
      5     6     4     19.8      164.    116.      3.91    3.09      17.7     0.5
      6     6     5     19.7      145     175       3.62    2.77      15.5     0  
      7     8     3     15.0      358.    194.      3.12    4.10      17.1     0  
      8     8     5     15.4      326     300.      3.88    3.37      14.6     0  
      # i 11 more variables: am_mean <dbl>, carb_mean <dbl>, mpg_sd <dbl>,
      #   disp_sd <dbl>, hp_sd <dbl>, drat_sd <dbl>, wt_sd <dbl>, qsec_sd <dbl>,
      #   vs_sd <dbl>, am_sd <dbl>, carb_sd <dbl>
      # A tibble: 8 x 56
          cyl  gear mpg_mean disp_mean hp_mean drat_mean wt_mean qsec_mean vs_mean
        <dbl> <dbl>    <dbl>     <dbl>   <dbl>     <dbl>   <dbl>     <dbl>   <dbl>
      1     4     3     21.5      120.     97       3.7     2.46      20.0     1  
      2     4     4     26.9      103.     76       4.11    2.38      19.6     1  
      3     4     5     28.2      108.    102       4.1     1.83      16.8     0.5
      4     6     3     19.8      242.    108.      2.92    3.34      19.8     1  
      5     6     4     19.8      164.    116.      3.91    3.09      17.7     0.5
      6     6     5     19.7      145     175       3.62    2.77      15.5     0  
      7     8     3     15.0      358.    194.      3.12    4.10      17.1     0  
      8     8     5     15.4      326     300.      3.88    3.37      14.6     0  
      # i 47 more variables: am_mean <dbl>, carb_mean <dbl>, mpg_sd <dbl>,
      #   disp_sd <dbl>, hp_sd <dbl>, drat_sd <dbl>, wt_sd <dbl>, qsec_sd <dbl>,
      #   vs_sd <dbl>, am_sd <dbl>, carb_sd <dbl>, cov_var_1 <dbl>, cov_var_2 <dbl>,
      #   cov_var_3 <dbl>, cov_var_4 <dbl>, cov_var_5 <dbl>, cov_var_6 <dbl>,
      #   cov_var_7 <dbl>, cov_var_8 <dbl>, cov_var_9 <dbl>, cov_var_10 <dbl>,
      #   cov_var_11 <dbl>, cov_var_12 <dbl>, cov_var_13 <dbl>, cov_var_14 <dbl>,
      #   cov_var_15 <dbl>, cov_var_16 <dbl>, cov_var_17 <dbl>, cov_var_18 <dbl>, ...

# `svor_exc()` examples work

    Code
      data("ordmvnorm")
      x <- ordmvnorm[, 3:7]
    Warning <rlang_warning>
      Dropping 'mi_df' class as required column was removed.
    Code
      y <- attr(ordmvnorm, "instance_label")
      mdl1 <- svor_exc(x, y)
    Message <rlang_message>
      The SMO algorithm reached the maximum of 500 steps.
    Code
      predict(mdl1, x)
    Output
      # A tibble: 1,000 x 1
         .pred_class
         <fct>      
       1 1          
       2 1          
       3 2          
       4 1          
       5 1          
       6 1          
       7 1          
       8 4          
       9 2          
      10 2          
      # i 990 more rows
    Code
      predict(mdl1, x, type = "raw")
    Output
      # A tibble: 1,000 x 1
           .pred
           <dbl>
       1 -0.464 
       2 -1.08  
       3  0.500 
       4 -0.253 
       5  0.0886
       6 -0.0116
       7 -0.146 
       8  2.15  
       9  0.266 
      10  0.216 
      # i 990 more rows

