#' mass balance Function
#' 
#' Doesn't return anything but prints to screen if mass does not balance after the equations for biological growth have been derived
#' This is only run if checkMassConv is TRUE
#' 
#' @aliases massBalanceFunc
#' @param uptake Matrix (with names) where columns are resources and rows are pathways, giving uptake rate (mass/time) of given strain 
#' @param production Matrix (with names) where columns are resources and rows are pathways, giving production rate (mass/time) of given strain 
#' @param growthRate (vector) microbial growth rate (mass per unit time) for one strain on each metabolic pathway
#' @param balanceTol (scalar) Defined in microPopModel input list checkingOptions
#' @param strainName (string) Name of strain in ODE solver loop
#' @export
#' 
massBalanceFuncDefault = function(uptake, production, growthRate, balanceTol, strainName) {
    
    flag = 0
    
    mass.diff = sum(uptake, na.rm = TRUE) - sum(production, na.rm = TRUE) - sum(growthRate, 
        na.rm = TRUE)
    if (mass.diff > balanceTol) {
        warning(paste("MICROPOP WARNING: mass", mass.diff, "is being lost by", strainName))
        flag = 1
    }
    if (mass.diff < -1 * balanceTol) {
        warning(paste("MICROPOP WARNING: mass", -mass.diff, "is being generated by", strainName))
        flag = 1
    }
    if (flag == 1) {
        warning(paste("uptake", sum(uptake, na.rm = TRUE)))
        warning(paste("sum of prod", sum(production, na.rm = TRUE)))
        warning(paste("growth", sum(growthRate, na.rm = TRUE)))
    }
}
