% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{step_filter}
\alias{step_filter}
\title{Filter rows from survey data}
\usage{
step_filter(
  svy,
  ...,
  .by = NULL,
  .copy = use_copy_default(),
  comment = "Filter step",
  .level = "auto"
)
}
\arguments{
\item{svy}{A \link{Survey} or \link{RotativePanelSurvey} object.}

\item{...}{Logical expressions evaluated against the data. Each must
return a logical vector. Multiple conditions are combined with AND.}

\item{.by}{Optional grouping variable(s) for within-group filtering.}

\item{.copy}{Whether to operate on a copy (default: \code{\link[=use_copy_default]{use_copy_default()}}).}

\item{comment}{Descriptive text for the step (default \code{"Filter step"}).}

\item{.level}{For \link{RotativePanelSurvey}, the level to apply
(default \code{"auto"}): \code{"implantation"}, \code{"follow_up"}, or \code{"auto"} (both).}
}
\value{
The survey object with rows filtered and the step recorded.
}
\description{
Creates a step that filters (subsets) rows from the survey data based
on logical conditions. Multiple conditions are combined with AND.
}
\details{
\strong{Lazy evaluation (default):} Like all steps, filter is recorded but
\strong{not executed} until \code{\link[=bake_steps]{bake_steps()}} is called.
}
\examples{
svy <- Survey$new(
  data = data.table::data.table(
    id = 1:10, age = c(15, 25, 35, 45, 55, 65, 75, 20, 30, 40), w = 1
  ),
  edition = "2023", type = "test", psu = NULL,
  engine = "data.table", weight = add_weight(annual = "w")
)
svy <- svy |> step_filter(age >= 18) |> bake_steps()
nrow(get_data(svy))

}
\seealso{
Other steps: 
\code{\link{bake_steps}()},
\code{\link{get_steps}()},
\code{\link{step_compute}()},
\code{\link{step_join}()},
\code{\link{step_recode}()},
\code{\link{step_remove}()},
\code{\link{step_rename}()},
\code{\link{step_validate}()},
\code{\link{view_graph}()}
}
\concept{steps}
