% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provenance.R
\name{print.metasurvey_provenance}
\alias{print.metasurvey_provenance}
\title{Print provenance information}
\usage{
\method{print}{metasurvey_provenance}(x, ...)
}
\arguments{
\item{x}{A \code{metasurvey_provenance} list.}

\item{...}{Additional arguments (unused).}
}
\value{
Invisibly returns \code{x}.
}
\description{
Print provenance information
}
\examples{
s <- survey_empty("ech", "2023")
s <- set_data(s, data.table::data.table(age = 18:65))
s <- step_compute(s, age2 = age * 2)
s <- bake_steps(s)
print(provenance(s))

}
\seealso{
Other provenance: 
\code{\link{print.metasurvey_provenance_diff}()},
\code{\link{provenance}()},
\code{\link{provenance_diff}()},
\code{\link{provenance_to_json}()}
}
\concept{provenance}
