% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_tree.R
\name{make_decision_tree}
\alias{make_decision_tree}
\title{Evaluate utilities}
\usage{
make_decision_tree(tree.data)
}
\arguments{
\item{tree.data}{data.table with decision tree information.}
}
\value{
igraph object containing the graph of the decision tree.
}
\description{
Create decision tree for MAUT models exporting to an igraph object.
}
\details{
With the tree information loaded by the \code{\link{read_tree}} the decision tree
could be represented like an igraph object.
}
\examples{
library( data.table )
library( igraph )
file <- system.file("extdata", "tree.csv", package = "mau" )
tree.data <- read_tree( file, skip = 0, nrows = 8 )
tree <- make_decision_tree( tree.data )
plot( tree )
}
\seealso{
\code{\link{read_tree}}
}
\author{
Pedro Guarderas, Andrés Lopez
\email{pedro.felipe.guarderas@gmail.com}
}
