% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCXYZanalysis.R
\docType{methods}
\name{show,ABCXYZComparison-method}
\alias{show,ABCXYZComparison-method}
\title{Shows an ABCXYZComparison object}
\usage{
\S4method{show}{ABCXYZComparison}(object)
}
\arguments{
\item{object}{The \code{ABCXYZComparison} object}
}
\description{
Shows an \code{ABCXYZComparison} object as a table consisting of the absolute and relative amount of each item,
the cumulative relative amount and the ABC-class for both \code{ABCXYZData} objects. It furthermore shows the
ABC comparison of the two objects. If XY and YZ parameters have been specified for computing the
\code{ABCXYZData} object, the table also includes a column for the XYZ coefficient, the XYZ-class, the
ABC/XYZ-class and the XYZ comparison.
}
\examples{
data("Amount")
data1 = Amount[sample(1:nrow(Amount), 1000),]
data2 = Amount[sample(1:nrow(Amount), 1000),]
abcxyzData1 = computeABCXYZAnalysis(data1, value = "value", item = "item", timestamp = "date",
                                    temporalAggregation = "day", XY = 0.5, YZ = 1)
abcxyzData2 = computeABCXYZAnalysis(data2, value = "value", item = "item", timestamp = "date",
                                    temporalAggregation = "day", XY = 0.5, YZ = 1)
comparison = compare(abcxyzData1, abcxyzData2)
comparison
}
\seealso{
\code{\link[=ABCXYZComparison-class]{ABCXYZComparison}} \code{\link[=ABCXYZComparison-class]{compare}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
