% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radii.R
\name{get_mass_props_and_unc_and_radii_and_unc}
\alias{get_mass_props_and_unc_and_radii_and_unc}
\title{Get mass properties and uncertainties and radii of gyration and uncertainties}
\usage{
get_mass_props_and_unc_and_radii_and_unc(df, id)
}
\arguments{
\item{df}{A data frame with (at least) these columns: \code{id}, \code{mass}, \code{Cx},
\code{Cy}, \code{Cz}, \code{Ixx}, \code{Iyy}, \code{Izz}, \code{Ixy}, \code{Ixz}, \code{Iyz}, \code{POIconv}, \code{Ipoint},
\code{sigma_mass}, \code{sigma_Cx}, \code{sigma_Cy}, \code{sigma_Cz},\code{sigma_Ixy}, \code{sigma_Ixz},
\code{sigma_Iyz}, \code{kx}, \code{ky}, \code{kz}, \code{sigma_kx}, \code{sigma_ky}, \code{sigma_kz}.}

\item{id}{The \code{id} value of the desired row.}
}
\value{
A list with the following named elements:
\itemize{
\item \code{mass} Numeric mass.
\item \code{center_mass} Numeric 3-vector center of mass.
\item \code{point} Logical indicating point mass. The inertia of point masses is excluded from calculations.
\item \code{inertia} Numeric 3x3 matrix inertia tensor. The signs of the off-diagonal elements of the inertia tensor
are determined by \code{POIconv}. For example, the \eqn{xy} element of the inertia
tensor is \code{Ixy} if \code{POIconv} is "-"; it is -\code{Ixy} if \code{POIconv} is "+".
\item \code{sigma_mass} Numeric mass uncertainty.
\item \code{sigma_center_mass} Numeric 3-vector center of mass uncertainties.
\item \code{sigma_inertia} Numeric 3x3 matrix inertia tensor uncertainties.
\item \code{radii_gyration} Numeric 3-vector radii of gyration.
\item \code{sigma_radii_gyration} Numeric 3-vector radii of gyration uncertainties.
}
}
\description{
\code{get_mass_props_and_unc_and_radii_and_unc()} creates a mass properties and uncertainties
and radii of gyration and uncertainties list from a selected row in a data frame.
}
\examples{
mp_table_small_rollup <- rollup_mass_props_and_unc(mp_tree_small, mp_table_small)
radii_and_unc_table <- rollup_radii_of_gyration_unc(
                          mp_tree_small, add_radii_of_gyration(mp_table_small_rollup))
get_mass_props_and_unc_and_radii_and_unc(radii_and_unc_table, "C.1")

}
