% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fit.R
\name{fit.likelihood_model}
\alias{fit.likelihood_model}
\title{Default MLE solver for subclasses of \code{likelihood_model}.}
\usage{
\method{fit}{likelihood_model}(object, ...)
}
\arguments{
\item{object}{The \code{likelihood_model} object}

\item{...}{Additional arguments to pass into the likelihood model's
\code{loglik}, \code{score}, and \code{hess_loglik} constructors.}
}
\value{
An MLE solver (function) that returns an MLE object and accepts as
arguments:
\itemize{
\item \code{df}: The data frame
\item \code{par}: The initial guess for the parameters
\item \code{control}: Control parameters for the optimization algorithm
\item \code{...}: Additional arguments to pass into the likelihood model's
constructed functions from \code{loglik}, \code{score}, and \code{hess_loglik}.
}
}
\description{
Note that \code{likelihood_model} is not a class, but a concept,
that other likelihood models implement. They should add
\code{likelihood_model} to their class definition, and then
they can use this function to compute the MLE.
}
\details{
This function uses the \code{optim} function to find the MLE of the
parameters of a likelihood model. It uses the \code{loglik} and \code{score}
methods to compute the log-likelihood and score function, respectively.

There are a few interesting options for the \code{control} argument:
\itemize{
\item \code{method}: The optimization method to use. The default is \code{Nelder-Mead},
which is a derivative-free method. Other options like include \code{BFGS}
are gradient-based methods, which may be preferable if you provide
a \code{score} function (rather than using the default finite-difference). There
is also the \code{SANN} method, which is a simulated annealing method. This
method is useful for multimodal likelihood functions, where the MLE
may be sensitive to the initial guess. The \code{SANN} method is a more global
method, but it is slower and may require some tweaking. Regardless,
if you do use \code{SANN}, you should follow it up with a local search
method like \code{Nelder-Mead} to refine the solution.
}
}
