% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptStats.R
\name{reptStats}
\alias{reptStats}
\title{Summarize Taxonomic Composition}
\usage{
reptStats(
  x = letsRept::allReptiles,
  verbose = FALSE,
  order = NULL,
  suborder = NULL,
  family = NULL,
  genus = NULL
)
}
\arguments{
\item{x}{A data frame containing reptile taxonomy data. Defaults to the internal dataset \code{letsRept::allReptiles}.}

\item{verbose}{Logical. If \code{TRUE}, returns a list of taxon names by rank. If \code{FALSE} (default), returns a summary table of counts.}

\item{order}{Optional. A character string specifying a taxonomic order to filter by (e.g., \code{"Squamata"}).}

\item{suborder}{Optional. A character string specifying a taxonomic suborder to filter by (e.g., \code{"Serpentes"}).}

\item{family}{Optional. A character string specifying a family to filter by (e.g., \code{"Elapidae"}).}

\item{genus}{Optional. A character string specifying a genus to filter by (e.g., \code{"Micrurus"}).}
}
\value{
Either a named list of taxonomic units (\code{verbose = TRUE}) or a data frame with taxonomic ranks and the number of units per rank (\code{verbose = FALSE}).
}
\description{
This function summarizes the taxonomic content of a species list, typically an object created with \code{reptSpecies} with higher taxa information.
If no object is provided it summarizes the internal dataset \code{allReptiles}.
}
\details{
The output can be either a compact table with taxonomic unit counts or a verbose list of names within each rank.

Optional arguments allow the user to filter the dataset by specific taxonomic levels (e.g., order, suborder, family, genus) before summarizing.
}
\examples{
# Basic usage with default dataset
reptStats()

# Verbose summary listing elements in each rank
reptStats(verbose = TRUE)

# Filter by family and return summary table
reptStats(family = "Elapidae")

# Combine filters and return list
reptStats(suborder = "Serpentes", verbose = TRUE)

}
