% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medinfo.R
\name{medinfo}
\alias{medinfo}
\title{compute info on distances to medoids/centroids}
\usage{
medinfo(cluster, data, silwidths)
}
\arguments{
\item{cluster}{named vector}

\item{data}{matrix with raw data}

\item{silwidths}{matrix with silhouette widths}
}
\value{
list with component widths. The widths object is a matrix
with one row per data item, with column med_ratio holding
the sharpness measure.
}
\description{
Analogous in structure to silinfo and neiinfo, it computes
a "widths" matrix assessing how well each data point belongs
to its cluster. Here, this measure is the ratio of two distances:
in the numerator, the distance from the point to the nearest cluster center,
and in the denominator, from the point to its own cluster center.
}
\examples{

# construct a manual clustering of the iris dataset
iris.data = iris[, 1:4]
rownames(iris.data) = paste0("iris_", seq_len(nrow(iris.data)))
iris.dist = dist(iris.data)
iris.clusters = setNames(as.integer(iris$Species), rownames(iris.data))

# compute sharpnessvalues based on medoids
iris.silinfo = silinfo(iris.clusters, iris.dist)
medinfo(iris.clusters, iris.data, iris.silinfo$widths)

}
