% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{log_report}
\alias{log_report}
\title{Log Join Report to File}
\usage{
log_report(report, file, append = FALSE, timestamp = TRUE)
}
\arguments{
\item{report}{A \code{JoinReport} object from \code{\link[=join_spy]{join_spy()}} or retrieved via
\code{\link[=last_report]{last_report()}}.}

\item{file}{File path to write to. Extension determines format:
\itemize{
\item \code{.txt} or \code{.log}: Plain text (human-readable)
\item \code{.json}: JSON format (machine-readable)
\item \code{.rds}: R binary format (preserves all data)
}}

\item{append}{Logical. If \code{TRUE}, appends to existing file (text/log only).
Default \code{FALSE}.}

\item{timestamp}{Logical. If \code{TRUE} (default), includes timestamp in output.}
}
\value{
Invisibly returns the file path.
}
\description{
Writes a \code{JoinReport} object to a file for audit trails and reproducibility.
Supports plain text, JSON, and RDS formats.
}
\examples{
orders <- data.frame(id = 1:3, value = c(10, 20, 30))
customers <- data.frame(id = c(1, 2, 4), name = c("A", "B", "D"))

report <- join_spy(orders, customers, by = "id")

# Log to temporary file
tmp <- tempfile(fileext = ".log")
log_report(report, tmp, append = TRUE)
unlink(tmp)

}
\seealso{
\code{\link[=join_spy]{join_spy()}}, \code{\link[=last_report]{last_report()}}
}
