% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_stats.R
\name{sensitivity_stats}
\alias{sensitivity_stats}
\alias{sensitivity_stats.iv_fit}
\alias{sensitivity_stats.iv.sensemakr}
\title{Sensitivity statistics for instrumental variable estimates}
\usage{
sensitivity_stats(...)

\method{sensitivity_stats}{iv_fit}(model, parm = "iv", q = 1, alpha = 0.05, min = TRUE, ...)

\method{sensitivity_stats}{iv.sensemakr}(model, parm = "iv", q = 1, alpha = 0.05, min = TRUE, ...)
}
\arguments{
\item{...}{further arguments passed to or from other methods.}

\item{model}{a model created with the function \code{\link{iv_fit}}.}

\item{parm}{contour plots of which estimate? Options are \code{iv} for instrumental variable estimates, \code{fs} for first-stage estimates, and \code{rf} for reduced-form estimates.}

\item{q}{percent change of the effect estimate that would be deemed problematic. Default is 1, which means a reduction of 100\% of the current effect estimate (bring estimate to zero).}

\item{alpha}{significance level.}

\item{min}{should we consider biases as large or larger than a certain amount? Default is \code{TRUE}.}
}
\value{
A \code{\link{data.frame}} with columns for the estimate, confidence interval
bounds (lower and upper), t-value, extreme robustness value (\code{xrv_qa}),
robustness value (\code{rv_qa}), and the parameters used (\code{q}, \code{min},
\code{alpha}, \code{dof}).
}
\description{
Convenience function that computes robustness values for IV estimates as well as auxiliary first stage and reduced form regressions.
}
\examples{
data("card")
y <- card$lwage
d <- card$educ
z <- card$nearc4
x <- model.matrix( ~ exper + expersq + black + south + smsa + reg661 + reg662 +
                     reg663 + reg664 + reg665+ reg666 + reg667 + reg668 + smsa66,
                   data = card)
card.fit <- iv_fit(y, d, z, x)

# sensitivity statistics for the IV estimate
sensitivity_stats(card.fit)

# sensitivity statistics for the first-stage
sensitivity_stats(card.fit, parm = "fs")

}
