% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfPlotEstimation}
\alias{ipfPlotEstimation}
\title{Plots the estimated locations}
\usage{
ipfPlotEstimation(model, estimation, testpos = NULL, observations = c(1),
  reverseAxis = FALSE, showneighbors = FALSE, showLabels = FALSE,
  xlab = NULL, ylab = NULL, title = "")
}
\arguments{
\item{model}{an ipfModel}

\item{estimation}{an ipfEstimation}

\item{testpos}{position of the test observations}

\item{observations}{a numeric vector with the indices of estimations to plot}

\item{reverseAxis}{swaps axis}

\item{showneighbors}{plot the k selected neighbors}

\item{showLabels}{shows labels}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{title}{plot title}
}
\description{
Plots the estimated locations
}
\examples{

    model      <- ipfKnn(ipftrain[1:200, 1:168], ipftrain[1:200, 169:170])
    estimation <- ipfEstimate(model, ipftest[1:20, 1:168], ipftest[1:20, 169:170])
    ipfPlotEstimation(model, estimation, ipftest[1:20, 169:170],
                      observations = 1:4, showneighbors = TRUE,
                      reverseAxis = TRUE)

}
