% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_coefficient_matrix_create.R
\name{input_coefficient_matrix_create}
\alias{input_coefficient_matrix_create}
\title{Create an input coefficient matrix}
\usage{
input_coefficient_matrix_create(data_table, households = FALSE, digits = NULL)
}
\arguments{
\item{data_table}{A symmetric input–output table, a use table,
or margins/tax table retrieved by \code{\link[=iotable_get]{iotable_get()}}.}

\item{households}{Logical; include the households column if available.
Default \code{FALSE}.}

\item{digits}{Optional integer precision to round the resulting matrix.
Default \code{NULL} (no rounding).}
}
\value{
A \code{data.frame} containing the input coefficient matrix (products ×
products), with the key (row label) retained as the first column.
Any TOTAL rows/columns (\code{"cpa_total"}, \code{"total"}) are removed.
}
\description{
Create an input coefficient matrix from the input flow matrix and the
output vector. This is a thin wrapper around
\code{\link[=coefficient_matrix_create]{coefficient_matrix_create()}}, with \code{total = "output"} and
\code{return_part = "products"}.
}
\details{
The input coefficients of production activities may be interpreted as the
corresponding cost shares for products and primary inputs in total output.
Our terminology follows the
\href{https://ec.europa.eu/eurostat/documents/3859598/5902113/KS-RA-07-013-EN.PDF}{Eurostat
Manual of Supply, Use and Input–Output Tables}. In some sources this
is called the \emph{technological coefficients matrix}.
}
\examples{
cm <- input_coefficient_matrix_create(
  iotable_get(source = "germany_1995"),
  digits = 4
)
head(cm)

# Equivalent direct call:
cm2 <- coefficient_matrix_create(
  iotable_get(source = "germany_1995"),
  total = "output",
  return_part = "products",
  digits = 4
)

}
