% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oversampleDatRel.R
\name{oversampleDatRel}
\alias{oversampleDatRel}
\title{Oversampling and Data Relocation for Resampled Data}
\usage{
oversampleDatRel(
  x,
  y,
  method = "SMOTE",
  proportion = 1,
  p_of = 0,
  class_pos = NULL,
  ...
)
}
\arguments{
\item{x}{feature matrix or dataframe.}

\item{y}{class factor variable.}

\item{method}{oversampling method. Default is "SMOTE". Available methods are: \cr
"ADASYN": Adaptive Synthetic Sampling \cr
"ROS": Random Oversampling \cr
"ROSE": Randomly Over Sampling Examples \cr
"RSLSMOTE": Relocating safe-level SMOTE with minority outcast handling \cr
"RUS": Random Undersampling \cr
"SLSSMOTE": Safe-level Synthetic Minority Oversampling Technique \cr
"SMOTE": Synthetic Minority Oversampling Technique \cr
"SMOTEWB": SMOTE with boosting}

\item{proportion}{proportion of covered samples. A real number between \eqn{(0,1]}.
1 by default. Smaller numbers results in less dominant samples.}

\item{p_of}{proportion to increase cover radius. A real number between
\eqn{(0,\infty)}. Default is 0. Higher values tolerate other classes more.}

\item{class_pos}{Class name of synthetic data. Default is NULL. If NULL,
positive class is minority class.}

\item{...}{arguments to be used in specified method.}
}
\value{
an list which includes:
 \item{x_new}{dominant sample indexes.}
 \item{y_new}{dominant samples from feature matrix, x}
 \item{x_syn}{Radiuses of the circle for dominant samples}
 \item{i_dominant}{class names}
 \item{x_pos_dominant}{number of classes}
 \item{radii_pos_dominant}{proportions each class covered}
}
\description{
\code{oversampleDatRel} first oversamples using selected method
then relocates resampled data using Pure and Proper Class Cover Catch Digraph.
}
\details{
Oversampling using \code{DatRel}. Available oversampling methods are from
\code{SMOTEWB} package. "ROSE" generates samples from all classes. DatRel
relocates all class samples.
}
\examples{

library(SMOTEWB)
library(rcccd)

set.seed(10)
# adding data
x <- rbind(matrix(rnorm(2000, 3, 1), ncol = 2, nrow = 1000),
           matrix(rnorm(60, 6, 1), ncol = 2, nrow = 30))
y <- as.factor(c(rep("negative", 1000), rep("positive", 30)))

# adding noise
x[1001,] <- c(3,3)
x[1002,] <- c(2,2)
x[1003,] <- c(4,4)

# resampling
m_SMOTE <- SMOTE(x = x, y = y, k = 3)

# resampled data
plot(x, col = y, main = "SMOTE")
points(m_SMOTE$x_syn, col = "green")

m_DatRel <- oversampleDatRel(x = x, y = y, method = "SMOTE")

# resampled data after relocation
plot(x, col = y, main = "SMOTE + DatRel")
points(m_DatRel$x_syn, col = "green")

}
\author{
Fatih Saglam, saglamf89@gmail.com
}
