% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_cbs_muni.R
\name{combine_cbs_muni}
\alias{combine_cbs_muni}
\title{Combine municipalities data frames from different sheets}
\usage{
combine_cbs_muni(
  path,
  year,
  cols_city,
  cols_rc,
  data_domain = c("physical", "budget"),
  col_names = NULL,
  col_names_from = c("city_lc", "rc")
)
}
\arguments{
\item{path}{A character vector of length 1, denoting the local file path to the
municipal data file. A full list of available files by the CBS is at the
\href{https://www.cbs.gov.il/he/publications/Pages/2019/\%D7\%94\%D7\%A8\%D7\%A9\%D7\%95\%D7\%99\%D7\%95\%D7\%AA-\%D7\%94\%D7\%9E\%D7\%A7\%D7\%95\%D7\%9E\%D7\%99\%D7\%95\%D7\%AA-\%D7\%91\%D7\%99\%D7\%A9\%D7\%A8\%D7\%90\%D7\%9C-\%D7\%A7\%D7\%95\%D7\%91\%D7\%A6\%D7\%99-\%D7\%A0\%D7\%AA\%D7\%95\%D7\%A0\%D7\%99\%D7\%9D-\%D7\%9C\%D7\%A2\%D7\%99\%D7\%91\%D7\%95\%D7\%93-1999-2017.aspx}{relevant CBS page}.}

\item{year}{A numeric vector of length 1 denoting which year the data file
pointed in \code{path} is for. Currently supporting 2003-2015, since before 2003 the
data structure is very different, and after 2015 the file is already combined.}

\item{cols_city}{<\href{https://dplyr.tidyverse.org/reference/dplyr_tidy_select.html}{tidy-select}>
Columns to keep from the cities and local councils sheet.}

\item{cols_rc}{<\href{https://dplyr.tidyverse.org/reference/dplyr_tidy_select.html}{tidy-select}>
Columns to keep from the regional councils sheet. Should be in the same order
of desired columns as in \code{cols_city}, since the columns are matched by order.}

\item{data_domain}{A character vector of length 1, one of
\code{c("physical", "budget")}. Every Excel municipal data file has a few different
data domains, most notably physical and population data, and budget data.}

\item{col_names}{A character vector containing the new column names of the
output tibble. If \code{NULL} then the tibble uses the original column names.
Must be the same length as the number of columns picked in \code{cols}. If not \code{NULL},
overrides the choice in \code{col_names_from}.}

\item{col_names_from}{A character vector of length 1, one of
\code{c("city_lc", "rc")}. Denotes which column names should be kept - those from the
cities and local councils sheet, or those from the regional councils sheet.}
}
\value{
A tibble with municipal data for a specific year, with the columns from
\code{cols_city} and \code{cols_rc} bound by rows and matched by order of columns. Every row is a
municipality and every column is a different variable for this municipality in
that year. Be advised all columns are of type character, so you need to parse
the data types yourself at will. Column names are merged from the relevant headers,
and only single whitespaces are kept. Rows with more than 90\% empty cells (usually
rows with non-data notes) are removed.
}
\description{
This function is a wrapper around \code{read_cbs_muni()} to help in combining data
for cities, local councils and regional councils.
From 2015 and earlier, the Israeli CBS publishes municipal data on different
sheets and formats for cities and local councils, and for regional councils.
This function enables the user to combine the two data frames for selected
columns. It is up to the user to take care of the specific match between specific
columns.
}
\examples{
df_1 <- combine_cbs_muni(
  system.file("extdata", "2009.xls", package = "il.cbs.muni"),
  year = 2009,
  cols_city = c(1:7, 11),
  cols_rc = c(1:7, 25)
)

df_1 |>
  dplyr::glimpse()

df_2 <- combine_cbs_muni(
  system.file("extdata", "2009.xls", package = "il.cbs.muni"),
  year = 2009,
  cols_city = c(1:12),
  cols_rc = c(1:12),
  data_domain = "budget",
  col_names_from = "rc"
)

df_2 |>
  dplyr::glimpse()
}
