% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_support.R
\name{Datatrans}
\alias{Datatrans}
\title{Data transformation.}
\usage{
Datatrans(
  pkg,
  des,
  y,
  n.alts,
  n.sets,
  n.resp,
  bin,
  alt.names = NULL,
  coding = NULL,
  lvls = NULL
)
}
\arguments{
\item{pkg}{Indicates the desired estimation package. Options are
\code{RSGHB = \link[RSGHB]{doHB}}, \code{bayesm = \link[bayesm]{rhierMnlRwMixture}},
\code{bayesm::rbprobitGibbs = \link[bayesm]{rbprobitGibbs}} (previously, in package Mixed.Probit),
\code{mlogit = \link[mlogit]{mlogit}}, \code{logitr = \link[logitr]{logitr}},
\code{Rchoice = \link[Rchoice]{Rchoice}}, \code{gmnl = \link[gmnl]{gmnl}},
\code{ChoiceModelR = \link[ChoiceModelR]{choicemodelr}}.}

\item{des}{A design matrix in which each row is a profile.}

\item{y}{A numeric vector containing binary or discrete responses. See \code{bin} argument.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{n.sets}{Numeric value indicating the number of choice sets.}

\item{n.resp}{Numeric value indicating the number of respondents.}

\item{bin}{Logical value indicating whether the response vector contains
binary data (\code{TRUE}) or discrete data (\code{FALSE}). See \code{y} argument.}

\item{alt.names}{A character vector containing the names of the alternatives.
The default = \code{NULL}.}

\item{coding}{Type of coding that needs to be used for each attribute. To be used only for package "ChoiceModelR".
The default = \code{NULL}.}

\item{lvls}{A numeric vector which contains for each attribute the number
of levels. To be used only for package "ChoiceModelR". The default = \code{NULL}.}
}
\value{
The data ready to be used by the specified package.
}
\description{
Transforms the data into the desired data format required by different
estimation packages.
}
\details{
The design (\code{des}) specified should be the full aggregated design.
Thus, if all participants responded to the same design, \code{des} will be a repetition of
that design matrix.

The responses in \code{y} should be successive when there are multiple
respondents. There can be \code{n.sets} elements for each respondent with
discrete values indicating the chosen alternative for each set. Or there can
be \code{n.sets * n.alts} elements for each respondent with binary values
indicating for each alternative whether it was chosen or not. In the latter
case the \code{bin} argument should be \code{TRUE}.

\code{n.sets} indicates the number of sets each respondent responded to. It is
assumed that every responded responded to the same number of choice sets.
}
\examples{
idefix.data <- aggregate_design 
des <- as.matrix(idefix.data[, 3:8], ncol = 6)
y <- idefix.data[, 9]
bayesm.data <- Datatrans(pkg = "bayesm", des = des, y = y, 
n.alts = 2, n.sets = 8, n.resp = 7, bin = TRUE)
rbprobit.data <- Datatrans(pkg = "bayesm::rbprobitGibbs", des = des, y = y,
 n.alts = 2, n.sets = 8, n.resp = 7, bin = TRUE)
mlogit.data <- Datatrans(pkg = "mlogit", des = des, y = y,
 n.alts = 2, n.sets = 8, n.resp = 7, bin = TRUE)
ChoiceM.data <- Datatrans(pkg = "ChoiceModelR", des = des, y = y,
 n.alts = 2, n.sets = 8, n.resp = 7, bin = TRUE, coding = c("D", "D", "D"), lvls = c(3, 3, 3))
 
}
