% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadados.R
\name{ibge_metadata}
\alias{ibge_metadata}
\title{Metadata for an aggregate}
\usage{
ibge_metadata(aggregate)
}
\arguments{
\item{aggregate}{Numeric aggregate identifier.}
}
\value{
A list of class \code{ibge_metadata} with:
\itemize{
\item \code{id}, \code{name}, \code{url}, \code{survey}, \code{subject}
\item \code{periodicity}: list with frequency, start and end
\item \code{territorial_level}: list with administrative, special and ibge
\item \code{variables}: tibble with id, name, unit
\item \code{classifications}: tibble with id, name and list-column \code{categories},
where each element is a tibble with category_id, category_name,
category_unit and category_level
}
}
\description{
Retrieves complete metadata for an aggregate: name, survey, subject,
periodicity, territorial levels, variables, and classifications with
all their categories.
}
\examples{
\dontrun{
meta <- ibge_metadata(7060)
meta$variables
meta$classifications
tidyr::unnest(meta$classifications, categories)
}

}
