% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F0072.R
\name{bubble.gg.plot}
\alias{bubble.gg.plot}
\title{Create bubble heatmaps for genes in clusters or conditions.}
\usage{
bubble.gg.plot(
  x = NULL,
  gene = "NULL",
  data.type = "main",
  conds.to.plot = NULL,
  min.scale = -2.5,
  max.scale = 2.5,
  interactive = TRUE,
  write.data = FALSE,
  colour = "Expression",
  size = "Percent.Expressed",
  out.name = "plot",
  heat.colors = c("blue", "red")
)
}
\arguments{
\item{x}{A data frame containing gene counts for cells.}

\item{gene}{A set of gene names to be heatmapped.}

\item{data.type}{Choose from "main", "atac", atac.imputed and "imputed", default = "main".}

\item{conds.to.plot}{Choose the conditions you want to see in the plot, default = NULL (all conditions).}

\item{min.scale}{Set a minimum color scale, default = -2.5.}

\item{max.scale}{Set a maximum color scale, default = 2.5.}

\item{interactive}{If TRUE an html interactive file will be made, default = TRUE.}

\item{write.data}{Write export the data used for the plot plot, default = TFALSE.}

\item{colour}{Set color to "Percent.Expressed", or "Expression", , default = "Expression".}

\item{size}{Set size to "Percent.Expressed", or "Expression", , default = "Percent.Expressed".}

\item{out.name}{Output name for html file if interactive = TRUE, default = "plot".}

\item{heat.colors}{Colors for heatmap, default = c("blue" ,"white", "red").}
}
\value{
An object of class iCellR
}
\description{
This function takes an object of class iCellR and genes and provides a heatmap.
}
