% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hd.ord.R
\name{hd.ord}
\alias{hd.ord}
\title{Implement hot deck multiple imputation with ordinal variables.}
\usage{
hd.ord(data, ord, evs, m = 5, method=c("best.cell", "p.draw"),
cutoff=10, sdCutoff=1, optimizeSD = FALSE, optimStep = 0.1, optimStop = 5,
weightedAffinity = FALSE, impContinuous = c("HD", "mice"), IDvars = NULL, ...)
}
\arguments{
\item{data}{A data frame with missing values to be imputed using multiple hot deck imputation.}

\item{ord}{A vector of ordinal variables to be used on the LHS of the ordered probit regression. Variables must not contain missing values}

\item{evs}{A vector of explanatory variables to be used on the RHS of the ordered probit regression. Variables may contain missing values.}

\item{m}{Number of imputed datasets required.}

\item{method}{Method used to draw donors based on affinity either \dQuote{best.cell} (the default) or \dQuote{p.draw} for probabilistic draw.}

\item{cutoff}{A numeric scalar such that any variable with fewer than \code{cutoff} unique non-missing values will be considered discrete and necessarily imputed with hot deck imputation.}

\item{sdCutoff}{Number of standard deviations between observations such that observations fewer than \code{sdCutoff} standard deviations away from each other are considered sufficiently close to be a match, otherwise they are considered too far away to be a match.}

\item{optimizeSD}{Logical indicating whether the \code{sdCutoff} parameter should be optimized such that the smallest possible value is chosen that produces no thin cells from which to draw donors.  Thin cells are those where the number of donors is less than \code{m}.}

\item{optimStep}{The size of the steps in the optimization if \code{optimizeSD} is \code{TRUE}.}

\item{optimStop}{The value at which optimization should stop if it has not already found a value that produces no thin cells.  If this value is reached and thin cells still exist, a warning will be returned, though the routine will continue using \code{optimStop} as \code{sdCutoff}.}

\item{weightedAffinity}{Logical indicating whether a correlation-weighted affinity score should be used.}

\item{impContinuous}{Character string indicating how continuous missing data should be imputed.  Valid options are \dQuote{HD} (the default) in which case hot-deck imputation will be used, or \dQuote{mice} in which case multiple imputation by chained equations will be used.}

\item{IDvars}{A character vector of variable names not to be used in the imputation, but to be included in the final imputed datasets.}

\item{...}{Optional additional arguments to be passed down to the \code{mice} routine.}
}
\value{
The output is a list with the following elements:
\itemize{
\item{data}{An object of class \code{mi} which contains \code{m} imputed datasets.}
\item{affinity}{A matrix of affinity scores see \code{\link{affinity}}.}
\item{donors}{A list of donors for each missing observation based on the affinity score.}
\item{draws}{The \code{m} observations drawn from donors that were used for the multiple imputations.}
\item{max.emp.aff}{Normalization constant for each row of affinity scores; the maximum possible value of the affinity scores if correlation-weighting is used.}
\item{max.the.aff}{Normalization constant for each row of affinity scores; the number of columns in the original data. }
\item{data.orig}{Original data fed into the function}
\item{data.orig.na.omit}{Original data without missing values}
\item{data.cut}{Data after cutpoint replacements}
\item{plr.out}{Results \code{polr}}
\item{plr.df}{Results of \code{polr} as a data frame}
\item{int.dfs}{A list of intercepts as data frames}
\item{ord.new.lev}{New ordinal variable levels}
\item{ord.new.lev.num}{Numeric version of new ordinal levels}
}
}
\description{
This function adapts the \dQuote{hot.deck} function to impute data with missing observations by specifically accounting for ordinal variables.
The ordinal variable is regressed on specified meaningful explanatory variables with the \code{polr} ordered probit approach.
The approach assumes an underlying latent continuous variable and estimates the distances between ordinal variable categories.
Ordinal levels are replaced with mid-cutpoints of the newly estimated intercepts. Categories that are not supported by the data are dropped.
The resulting categories are used to impute the data with multiple hot deck imputation with either the \dQuote{best cell} method (default) or the \dQuote{probabilistic draw} method.
Any number of ordinal variables can be specified. The specified ordinal variables must not contain missing values.
}
\examples{
data(ampData)
hd.ord(data = ampData,
      ord = c("Educ", "Interest"),
      evs = c("Dem", "Black", "Empl", "Male", "Inc", "Age"))

}
