% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_projection.R
\name{hexify_set_precision}
\alias{hexify_set_precision}
\title{Set inverse projection precision}
\usage{
hexify_set_precision(
  mode = c("fast", "default", "high", "ultra"),
  tol = NULL,
  max_iters = NULL
)
}
\arguments{
\item{mode}{Preset mode: "fast", "default", "high", or "ultra"}

\item{tol}{Custom tolerance (overrides mode if provided)}

\item{max_iters}{Custom max iterations (overrides mode if provided)}
}
\value{
Invisible NULL
}
\description{
Controls the accuracy/speed tradeoff for inverse Snyder projection.
}
\examples{
hexify_set_precision("high")
hexify_set_precision(tol = 1e-12, max_iters = 100)
}
\seealso{
Other projection: 
\code{\link{hexify_build_icosa}()},
\code{\link{hexify_face_centers}()},
\code{\link{hexify_forward}()},
\code{\link{hexify_forward_to_face}()},
\code{\link{hexify_get_precision}()},
\code{\link{hexify_inverse}()},
\code{\link{hexify_projection_stats}()},
\code{\link{hexify_set_verbose}()},
\code{\link{hexify_which_face}()}
}
\concept{projection}
