% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_for_existence.R
\name{check_for_existence}
\alias{check_for_existence}
\title{check_for_existence}
\usage{
check_for_existence(data, save_names = "save_names", dir = "heaps_of")
}
\arguments{
\item{data}{A dataframe that contains URLs that you want to download and the names
that you want to save them as.}

\item{save_names}{The name of the column whose values should be the saved
file names where the downloaded file will be saved, \code{save_names} by default.}

\item{dir}{The directory to download files to, current working directory by default.}
}
\value{
The \code{data} dataframe with a column specifying whether the file has
been downloaded.
}
\description{
The \code{check_for_existence} function looks at the folder that you
are going to save your PDFs to and checks whether you have already got any of
them. It then suggests that you filter to remove them.
}
\examples{
\dontrun{two_pdfs <-
 tibble::tibble(
  locations_are = c("https://osf.io/preprints/socarxiv/z4qg9/download",
    "https://osf.io/preprints/socarxiv/a29h8/download"),
  save_here = c("competing_effects_on_the_average_age_of_infant_death.pdf",
     "cesr_an_r_package_for_the_canadian_election_study.pdf")
   )

heapsofpapers::get_and_save(
data = two_pdfs,
links = "locations_are",
save_names = "save_here"
)

heapsofpapers::check_for_existence(data = two_pdfs, save_names = "save_here")
}
}
