% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cba.R
\name{cba}
\alias{cba}
\title{Cost-benefit analysis}
\usage{
cba(
  output_attribute = NULL,
  impact_benefit = NULL,
  valuation,
  cost,
  discount_rate_benefit = NULL,
  discount_rate_cost = NULL,
  inflation_rate = NULL,
  discount_shape = "exponential",
  n_years_benefit = 1,
  n_years_cost = 1
)
}
\arguments{
\item{output_attribute}{\code{List} produced by \code{healthiar::attribute_health()}, \code{healthiar::attribute_lifetable()} or \code{healthiar::compare()} as results.}

\item{impact_benefit}{\code{Numeric value} referring to the positive health impact as result of a reduction of harmful exposure.}

\item{valuation}{\code{Numberic value} referring to unit value of a health impact.}

\item{cost}{\code{Numeric value} referring to the investment cost to achieve the reduction of exposure.}

\item{discount_rate_benefit, discount_rate_cost}{\code{Numeric value} referring to the the discount rate used in the benefit and the cost side (respectively). Their values determine the approach of cost-benefit analysis: direct approach (if the same discount_rate is used for cost and benefit) and indirect approach (different discount rates).}

\item{inflation_rate}{\code{Numeric value} between 0 and 1 referring to the annual inflation (increase of prices). Only to be entered if nominal (not real) discount rate is entered in the function. Default value = NULL (assuming no nominal discount rate).}

\item{discount_shape}{\code{String} referring to the assumed equation for the discount factor. By default: \code{"exponential"}. Otherwise: \code{"hyperbolic_harvey_1986"} or \code{"hyperbolic_mazur_1987"}.}

\item{n_years_benefit, n_years_cost}{\code{Numeric value} referring to number of years in the future to be considered in the benefit and cost side (respectively). Years for discounting and/or inflation. Be aware that the year 0 (without discounting/inflation, i.e. the present) is not be counted here. If a vector is entered in the argument impact, n_years does not need to be entered (length of impact = n_years + 1)}
}
\value{
This function returns a \code{list} containing:

1) \code{cba_main} (\code{tibble}) containing the main CBA results;
\itemize{
 \item \code{net_benefit} (\code{numeric} column) containing the difference between benefit and cost (i.e. benefit - cost)
 \item \code{benefit} (\code{numeric} column) containing discounted benefit (i.e. monetized attributable health impact)
 \item \code{cost} (\code{numeric} column) containing discounted cost
 \item And many more
}

2) \code{cba_detailed} (\code{list}) containing detailed (and interim) results.
\itemize{
 \item \code{benefit} (\code{list})
 \item \code{cost} (\code{tibble})
}

If the argument \code{output_attribute} was specified, then the two results elements are added to the existing output.
}
\description{
This function performs a cost-benefit analysis.
It is assumed that the benefit is caused by the positive health impacts of a policy intervention,
which generates some costs.
}
\details{
\strong{Methodology}

This function provides as output three types of cost-benefit indicators
\insertCite{Boardman2018_book}{healthiar}:

\itemize{
 \item net benefit
 \item cost-benefit ratio
 \item return of investment}


Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#cost-benefit-analysis}{cost-benefit analysis}
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#monetization}{monetization}}
}
\examples{
# Goal: performs a cost-benefit analysis using an existing output
# of a attribute_... function

output_attribute <- attribute_health(
  erf_shape = "log_linear",
  rr_central = 1.369,
  rr_increment = 10,
  exp_central = 8.85,
  cutoff_central = 5,
  bhd_central = 30747
)

results <- cba(
  output_attribute = output_attribute,
  valuation = 50000,
  cost = 100000000,
  discount_shape = "exponential",
  discount_rate_benefit = 0.03,
  discount_rate_cost = 0.03,
  n_years_benefit = 5,
  n_years_cost = 5
)

results$cba_main |>
  dplyr::select(benefit, cost, net_benefit)


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Upstream: \code{\link{attribute_health}}
  \item Alternative: \code{\link{monetize}}
}
}
\author{
Alberto Castro & Axel Luyten
}
