% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnes.R
\name{cnes_variables}
\alias{cnes_variables}
\title{List CNES Variables}
\usage{
cnes_variables(type = "ST", search = NULL)
}
\arguments{
\item{type}{Character. File type to show variables for. Currently only
\code{"ST"} is fully documented. Default: \code{"ST"}.}

\item{search}{Character. Optional search term to filter variables by
name or description. Case-insensitive and accent-insensitive.}
}
\value{
A tibble with columns: variable, description, type, section.
}
\description{
Returns a tibble with available variables in the CNES data (ST type),
including descriptions and value types.
}
\examples{
cnes_variables()
cnes_variables(search = "tipo")
cnes_variables(search = "gestao")
}
\seealso{
Other cnes: 
\code{\link{cnes_cache_status}()},
\code{\link{cnes_clear_cache}()},
\code{\link{cnes_data}()},
\code{\link{cnes_dictionary}()},
\code{\link{cnes_info}()},
\code{\link{cnes_years}()}
}
\concept{cnes}
