\name{gsearlySimulate}
\alias{gsearlySimulate}
\title{Simulates data for a previously fitted gsearly model}
\usage{gsearlySimulate(mod, nsim=1, minsamp=c(1,1), mean=NULL, cmodel=NULL,
          sd=NULL, rho=NULL, full=FALSE)}
\description{Simulates multivariate Normal datasets based on a previously fitted
 gsearly model (see \code{\link{gsearlyModel}}).}
\arguments{
 \item{mod}{A previously fitted model from function \code{\link{gsearlyModel}}.}
 \item{nsim}{Number of required simulated datasets.}
 \item{minsamp}{Simulations where numbers at the first interim are less than
   \code{minsamp}, a vector of length 2 giving the minimum study sample size for
   the control and treatment groups, are excluded.}
 \item{mean}{A matrix of dimension \code{2 x s} giving mean values for the
   control (first row) and treatment (second row) groups for each of the
   \code{s} outcome time-points. If unset, these are taken directly from
   \code{mod}, where the control group mean is set to zero and the treatment
   group mean to \code{theta} for the primary outcome time-point with early
   means all set to zero (see \code{\link{gsearlyModel}}).}
 \item{cmodel}{Either a correlation model, \code{c("uniform", "exponential")},
   defined by correlation parameter \code{rho}, or a correlation matrix of
   dimensions \code{s x s}. If unset, taken from \code{mod}.}
 \item{sd}{The standard deviation of the outcome, that is assumed to be the same
   in both arms. Either a single value or a vector of length \code{s}, allowing
   \code{sd} to differ at each time-point. If unset, taken from \code{mod}.}
 \item{rho}{Correlation parameter if cmodel is set to \code{"uniform"} or
   \code{"exponential"}, otherwise ignored. If unset, taken from \code{mod}.}
 \item{full}{Either FALSE, which provides model details and parameters only or
   TRUE which provides full details of numbers and datasets in addition to the
   model details.}
}
\value{
 A list containing the following components.
 \item{model}{A list of model settings \code{nsim}, \code{s}, \code{tinterims},
   \code{tfu} and mean, covariance and correlation matrices.}
 \item{parameters}{A list of two matrices, comprising variances of beta (vbeta)
   and beta at each interim and final analysis.}
 \item{n}{A list of length 2 (control and treatment), each comprising of lists
   of matrices (for recruitment and follow-up times) showing sample sizes at
  each interim and final analysis for the \code{nsim} simulations.}
 \item{data}{A list of length 2 (control and treatment), each comprising of a
   list of length \code{nsim} comprising a list of matrices of outcome data
   (if \code{full=TRUE}) at interims and final analyses.}
}
\seealso{
 \code{\link{gsearlyModel}}, \code{\link{simdataExtract}}, \code{\link{modelParameters}}, \code{\link{gsearlyFit}}
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.2400,0.7200,0.9750)
 modeldesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(18,30), pow=0.9, vphi=0.5, m=2,
                   cmodel="uniform", sd=20, rho=0.5, theta=8, fp=fp, tn=tn)

 # Simulate data from this model
 simdata <- gsearlySimulate(mod=modeldesign, nsim=10, full=FALSE)
 # Model parameters
 simdata$parameters

 # Change correlation model
 newsimdata <- gsearlySimulate(mod=modeldesign, nsim=10,
                    cmodel="exponential", rho=0.75, full=FALSE)
 # Model parameters
 newsimdata$parameters

}
