% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSample.generate.sequential.R
\name{TwoSample.generate.sequential}
\alias{TwoSample.generate.sequential}
\title{Function to simulate two-sample composite endpoint data under staggered entry.}
\usage{
TwoSample.generate.sequential(
  lambda_0vec = c(1.15, 1.15),
  sizevec,
  beta.trt,
  calendar = 5,
  recruitment = 3,
  random.censor.rate,
  seed
)
}
\arguments{
\item{lambda_0vec}{Numeric vector of length 2 giving the baseline recurrent event rate parameters for two arms, default is \code{c(1.15, 1.15)}.}

\item{sizevec}{Integer vector of size 2 giving the group sizes.}

\item{beta.trt}{Numeric value giving the treatment effect coefficient applied to the treatment indicator (\code{Z1}) in the proportional mean model (arm 2 vs arm 1).}

\item{calendar}{Calendar time of the end of the trial (in years), default is \code{5}.}

\item{recruitment}{Length of the recruitment period (in years), default is \code{3}.}

\item{random.censor.rate}{Rate parameter for independent random right censoring.}

\item{seed}{Seed for reproducibility.}
}
\value{
A data frame in long format containing simulated composite endpoint data.
Each subject may contributing multiple rows corresponding to recurrent events, a terminal event (death), or censoring. The data include:
\itemize{
\item \code{group}: Arm indicator (\code{1} = control, \code{2}= treatment).
\item \code{id}: Subject identifier (unique across both arms).
\item \code{e}: Enrollment time on the calendar scale.
\item \code{event_time_cal}: Cumulative event time on the calendar scale.
\item \code{status}: Event indicator with values
\code{2}=recurrent event, \code{1}=death, and \code{0}=censoring.
\item \code{Z1}, \code{Z2}: Simulated covariates, where \code{Z1} is the treatment indicator (\code{0} for arm 1, \code{1} for arm 2).
\item \code{tau_star}: Subject-specific stopping time, the last event observed in \code{[0, tau_star]} is classified as death.
\item \code{death}: Binary indicator for death.
\item \code{recurrent}: Binary indicator for recurrent events.
\item \code{event}: Binary event indicator, \code{event = death + recurrent}.
\item \code{calendar}: Calendar time cutoff used to generate the returned data.
\item \code{lambda_0}: Baseline Poisson process rate parameter.
\item \code{lambda_star}: Rate parameter of an exponential distribution in generating \code{tau_star}.
\item \code{gamma_scale}, \code{gamma_shape}: Parameters of the Gamma distribution used to generate subject-specific frailty terms.
}
}
\description{
Simulate two-sample composite endpoints data with recurrent events and a terminal event
under two time scales: event time \code{t} and calendar time \code{s}. A uniform recruitment period is assumed,
and the function returns all observed data available at a specified calendar time. Recurrent event occurrences
are generated from an underlying Poisson process with subject-specific Gamma frailty.
}
\examples{
# Generate two-sample composite endpoint data
df <- TwoSample.generate.sequential(sizevec = c(200, 200),
beta.trt = 0.8, calendar = 5, recruitment = 3,
random.censor.rate = 0.05, seed = 2026)

}
\references{
Mao L, Lin DY. Semiparametric regression for the weighted composite endpoint of recurrent and terminal events. \emph{Biostatistics}. 2016 Apr; \strong{17(2)} :390-403.
}
