% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.R
\name{WorkerPool}
\alias{WorkerPool}
\title{Worker Pool R6 Class}
\description{
Worker Pool R6 Class

Worker Pool R6 Class
}
\details{
Manages a pool of async workers
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n_workers}}{Number of workers}

\item{\code{queue}}{Query queue}

\item{\code{results}}{Results list}

\item{\code{active}}{Whether pool is active
Initialize worker pool}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WorkerPool-new}{\code{WorkerPool$new()}}
\item \href{#method-WorkerPool-add}{\code{WorkerPool$add()}}
\item \href{#method-WorkerPool-process}{\code{WorkerPool$process()}}
\item \href{#method-WorkerPool-get_results}{\code{WorkerPool$get_results()}}
\item \href{#method-WorkerPool-clear_queue}{\code{WorkerPool$clear_queue()}}
\item \href{#method-WorkerPool-shutdown}{\code{WorkerPool$shutdown()}}
\item \href{#method-WorkerPool-clone}{\code{WorkerPool$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WorkerPool-new"></a>}}
\if{latex}{\out{\hypertarget{method-WorkerPool-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WorkerPool$new(n_workers = 4)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_workers}}{Number of workers
Add query to queue}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WorkerPool-add"></a>}}
\if{latex}{\out{\hypertarget{method-WorkerPool-add}{}}}
\subsection{Method \code{add()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WorkerPool$add(query, id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query to add}

\item{\code{id}}{Optional query ID
Process all queued queries}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WorkerPool-process"></a>}}
\if{latex}{\out{\hypertarget{method-WorkerPool-process}{}}}
\subsection{Method \code{process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WorkerPool$process(progress = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{progress}}{Show progress}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of results
Get results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WorkerPool-get_results"></a>}}
\if{latex}{\out{\hypertarget{method-WorkerPool-get_results}{}}}
\subsection{Method \code{get_results()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WorkerPool$get_results()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Results list
Clear queue
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WorkerPool-clear_queue"></a>}}
\if{latex}{\out{\hypertarget{method-WorkerPool-clear_queue}{}}}
\subsection{Method \code{clear_queue()}}{
Remove all queued items without processing them.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WorkerPool$clear_queue()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisible self
Shutdown pool
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WorkerPool-shutdown"></a>}}
\if{latex}{\out{\hypertarget{method-WorkerPool-shutdown}{}}}
\subsection{Method \code{shutdown()}}{
Shut down the worker pool and reset the future plan to sequential.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WorkerPool$shutdown()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisible self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WorkerPool-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WorkerPool-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WorkerPool$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
